package com.digiwin.athena.abt.application.dto.migration.abt.quartz;

import lombok.Data;
import org.quartz.Job;

/**
 * SchedulerJob Description
 *
 * @author majianfu
 * @date 2023/3/30
 * @since
 */
@Data
public class SchedulerJob<T extends Job> {
    /**
     * 必选，job名称，在group内要唯一
     */
    private String name;

    /**
     * 必选，job所在分组名称
     */
    private String group;

    /**
     * 必选，job实现类
     */
    private Class<T> jobClass;

    /**
     * 可选，job描述
     */
    private String desc;

    /**
     * 可选，job携带的业务数据的json字符串
     */
    private String jobDataJson;
}
