package com.digiwin.athena.abt.application.dto.migration.abt.sendmsg;

import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lzw
 * @date 2024/4/28
 * @description:
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmBackLogMsgDto {
    private AuthoredUser authoredUser;

    /**
     * 消息类型
     */
    private PtmMqOperation operation;

    /**
     * 待办
     */
    private PtmBacklogMessageDTO.Backlog backlog;

    /**
     * 待办创建时，标记是否需要创建任务群
     */
    private Boolean canCreateTaskTeam;

    /**
     * 发送新增IM消息时，用于标明合并任务是新增还是更新消息
     */
    private String messageType;

    private Long workItemId;
    /**
     *  是否最小化
     */
    private boolean minSplit;


}
