package com.digiwin.athena.abt.application.dto.migration.abt.sendmsg;

import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 发送任务（待办）的消息数据类
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class WorkItemMessageDTO {


    private Project project;

    private Task task;

    private PtmBacklogMessageDTO.Backlog backlog;

    private List<WorkItem> workItemList;

    /**
     * 发送新增IM消息时，用于标明合并任务是新增还是更新消息
     */
    private String messageType;

    private boolean minSplit;

    /**
     * 项目，对于atmc相当于task，对于PTM相当于project
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Project{

        /**
         * 项目id
         */
        private Long projectId;

        /**
         * 所属项目卡Id
         */
        private Long projectCardId;

        /**
         * KM定义的项目编号
         */
        private String projectDefCode;

        /**
         * 项目卡名称
         */
        private String name;

        /**
         * 项目卡时距开始时间
         */
        private LocalDateTime startTime;

        /**
         * 项目卡时距结束时间
         */
        private LocalDateTime endTime;

        /**
         * 项目卡的紧急度
         */
        private Integer emergency;

        /**
         * 项目卡当责者
         */
        private String personInCharge;

        /**
         * 项目卡当责者名称
         */
        private String personInChargeName;

        /**
         * 引擎类型
         */
        private String engineType;
    }

    /**
     * 任务,对于atmc相当于 bpmActivity，对于ptm相当于task
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Task{
        /**
         * 任务名称
         */
        private String taskName;

        /**
         * 任务创建时间
         */
        private LocalDateTime createTime;

        /**
         * 任务计划结束时间
         */
        private LocalDateTime planEndTime;

        /**
         * KM任务id
         */
        private String tmActivityId;

        /**
         * KM任务名称
         */
        private String tmActivityName;

        /**
         * 任务是否异常
         */
        private Boolean hasException;
    }

    /**
     * 待办，对于atmc相当于bpmActivityWorkitem，对于PTM相当于backlog
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class WorkItem{

        /**
         * 待办id
         */
        private Long id;

        /**
         * 待办id
         */
        private Long workItemId;


        /**
         * 待办执行人
         */
        private String performerId;

        /**
         * 待办执行人名称
         */
        private String performerName;

        /**
         * 创建类型
         */
        private Integer createType;

        /**
         * 来源待办id（TE的待办id）
         */
        private String fromWorkItemId;
    }
}
