package com.digiwin.athena.abt.application.dto.migration.abt.summary;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Objects;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CardJobData implements Serializable {

    private static final long serialVersionUID = -4665904058397978302L;
    /**
     *  任务编码
     */
    private String code;
    private String tenantId;

    private String pagCode;
    /**
     *  刷新类型(默认 代表刷新所有)  business(只刷新标签分组筛选排序)
     */
    private String refreshCardType;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardJobData that = (CardJobData) o;
        return Objects.equals(code, that.code) && Objects.equals(tenantId, that.tenantId) && Objects.equals(pagCode, that.pagCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, tenantId, pagCode);
    }
}
