package com.digiwin.athena.abt.application.dto.migration.abt.summary;

import com.digiwin.athena.abt.application.dto.migration.atmc.agile.CardDataParam;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class CardTaskContext {
    private List<CardDataParam> singleTasks;
    private List<CardDataParam> batchTasks;
    private AuthoredUser authoredUser;
    private int partitionSize;
    private int singleTaskSize;
    private int batchTaskSize;
    private int maxErrorSize;
    private Map<String,Map<Long,Integer>> idErrorCount;

    public CardTaskContext(AuthoredUser authoredUser,int partitionSize,int singleTaskSize,int batchTaskSize,int maxErrorSize) {
        this.authoredUser = authoredUser;
        this.singleTasks = Lists.newLinkedList();
        this.batchTasks = Lists.newLinkedList();
        this.partitionSize = partitionSize;
        this.singleTaskSize = singleTaskSize;
        this.batchTaskSize = batchTaskSize;
        this.maxErrorSize = maxErrorSize;
        this.idErrorCount = Maps.newHashMapWithExpectedSize(2);
    }
    public List<CardDataParam> getTask(boolean isBatch){
        return isBatch?batchTasks:singleTasks;
    }

    public void addTask(CardDataParam cardDataParam,boolean flag){
        getTask(flag).add(cardDataParam);
    }

    public void recordIdError(String pageCode,List<Long> ids){
        Map<Long, Integer> idToErrorMap = idErrorCount.computeIfAbsent(pageCode, e -> new HashMap<>());
        for (Long id : ids) {
            Integer num = idToErrorMap.computeIfAbsent(id, k -> 0);
            idToErrorMap.put(id,num);
        }
    }



}
