package com.digiwin.athena.abt.application.dto.migration.abt.task;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 分享码缓存DTO
 *
 * @author majfa
 * @date 2020.12.07
 * @since [迭代11-任务分享]
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SharingTaskDTO {
    private static final long serialVersionUID = 1L;

    /**
     * 分享者token
     */
    private String proxyToken;

    /**
     * 分享者租户Id
     */
    private String proxyTenantId;

    private Long proxyTenantSid;

    private String proxyTenantName;

    /**
     * 被分享的任务类型：任务卡or项目卡
     */
    private String taskType;

    /**
     * 被分享的任务类型
     */
    private Long taskId;

    /**
     * 是否为被分享
     */
    private Boolean isShared;
}
