package com.digiwin.athena.abt.application.dto.migration.abt.worker;

import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.core.ie.dto.IERedisSubTask;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @ClassName DataEntryTask
 * @Description 数据录入任务实体类
 * @Author zhuangli
 * @Date 2021/4/1 17:20
 * @Version 1.0
 **/
@Data
public class DataEntryTask extends IERedisSubTask {

    private String masterId;
    /**
     * 已作废
     */
    @Deprecated
    private String topic;
    private String actionId;
    private String userToken;
    private String tableKey;
//    private String tenantId;
    private String locale;
    /**
     * 已作废
     */
    @Deprecated
    private int batchNum;
    /**
     * 必须保证keyList的顺序和data的列顺序一致且匹配
     */
    private List<String> keyList;
    /**
     * 已作废
     */
    @Deprecated
    private List<List<Object>> data;
    /**
     * 已作废
     */
    @Deprecated
    private List<Map> dataList;

    /**
     * 导入参数
     */
    private ActionInfoDTO actionInfo;

    /**
     * 应用 code
     */
    private String application;

    /**
     * 活动 id
     */
    private String activityId;

    /**
     * 导出时 文件类型  0:业务数据录入  1:历史项目任务
     */
    private String type;

    /**
     * 文件在dmc中的url
     */
    private String fileUrl;

    /**
     * 批次信息
     */
    private List<BatchInfo> batchInfos;

    @Data
    public static class BatchInfo {
        /**
         * 当前批次
         */
        private Integer batchNum;

        /**
         * 当前批次携带总数
         */
        private Integer totalDataSize;

    }
}
