package com.digiwin.athena.abt.application.dto.migration.abt.worker;

import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.core.ie.dto.IERedisSubTask;
import lombok.Data;

import java.util.Map;

/**
 * @ClassName ExportFileMsg
 * @Description 异步导出MQ消息体
 * @Author lisheng
 * @Date 2023/9/20 17:20
 * @Version 1.0
 **/
@Data
public class ExportFileMsg extends IERedisSubTask {

    /**
     * 导出记录id
     */
    private String masterId;
    private String topic;
    private String actionId;
    private String userToken;
    private String tableKey;
//    private String tenantId;
    private String locale;

    /**
     * 导出文件参数
     */
    private DownloadBaseDataParamDTO downloadBaseDataParamDTO;

    /**
     * 导出历史项目任务参数
     */
    private Map<String, Object> historyDownloadBaseDataParam;

    /**
     * 应用 code
     */
    private String application;

    /**
     * 导出时 文件类型  0:业务数据录入  1:历史项目任务
     */
    private String type;

    /**
     * 导出历史项目任务明细参数
     */
    private DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO;

    /**
     * 具体某个的明细
     */
    private ExportBatchRecord exportBatchRecord;
}
