package com.digiwin.athena.abt.application.dto.migration.atmc.backlog;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TaskCardAbstractDTO {

    private long backlogId;

    /**
     * 检查项列表
     */
    private List<Map<String,Object>> checkItems;

    /**
     * SummaryLayout
     */
    private Map<String,Object> summaryLayout;

    /**
     * API异常信息
     */
    private Map<String,Object> error;

    /**
     * 待办数量列表，例如 待处理XX项
     */
    private List<Map<String,Object>> todoItems;

    /**
     * 建议操作
     */
    private String operation;
    /**
     * 字符串的summaryLayout
     */
    private String summaryLayoutStr;
    /**
     * 历史资讯
     */
    private String historyMessage;
}
