package com.digiwin.athena.abt.application.dto.migration.atmc.bpm;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * BPM 任务引擎可退回重签信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BpmTaskApprovePreviousActivityDTO {

    private List<Activitie> activities;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Activitie {

        private String activityId;

        private String activityName;

        private String createdTime;

        private int index;

        private String uid;

        private List<BpmTaskApproveActivityDTO.WorkItem> workitemList;

        @Data
        @AllArgsConstructor
        @NoArgsConstructor
        @Builder
        public static class WorkItem {
            private String agentPerformerId;
            private String performerId;
            private Integer performerType;
        }
    }

}
