package com.digiwin.athena.abt.application.dto.migration.atmc.eoc;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EocEmployeeDTO {

    private Long sid;
    /**
     * 员工工号
     */
    private String id;

    /**
     * 员工名称
     */
    private String name;

    private String email;

    private String telephone;

    private Boolean status;

    private List<EocEmployeeDepartDTO> depts;

    private EocEmployeeUserDTO user;

    private Long tenantSid;

    private String userId;

    private String userName;

    /**
     * 代理人id
     */
    private String agentId;

    /**
     * 代理人名称
     */
    private String agentName;

    @Data
    public static class EocEmployeeUserDTO {
        private String id;
        private String name;
        private String email;
        private String telephone;
    }

    @Data
    public static class EocEmployeeDepartDTO {
        private Long sid;
        /**
         * 部门ID
         */
        private String id;
        /**
         * 部门名称
         */
        private String name;
        /**
         * 部门主管EOC ID
         */
        private String deptDirectorId;
        /**
         * 是否是主部门
         */
        private Boolean mainDept;
    }
}
