package com.digiwin.athena.abt.application.dto.migration.atmc.im;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 创建IM任务群的对象
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ImBpmActivityTeamDTO {

    /**
     * 任务的Id，bpmActivityId
     */
    private Long bpmActivityId;

    /**
     * KM定义的任务名称
     */
    private String tmActivityName;

    /**
     * 任务计划结束时间
     */
    private LocalDateTime bpmActivityPlanEndTime;

    /**
     * 任务执行人列表
     */
    private List<Performer> performerList;

    /**
     * 任务的业务关联人
     */
    List<String> relatedUserList;

    /**
     * 是否外部任务
     */
    private int isExternal;

    /**
     * 多元交互方案
     */
    private String plan;

    /**
     * 租户SID
     */
    private String tenantSid;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * IM businessKey
     * PCC专用
     */
    private String imBusinessKey;

    /**
     * 所属主项目(项目卡)的id
     */
    private Long mainTaskId;

    /**
     * 所属主项目(项目卡)的当责者id
     */
    private String mainTaskPersonInCharge;

    /**
     * 所属主项目(项目卡)的当责者名称
     */
    private String mainTaskPersonInChargeName;


    /**
     * 任务执行人
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Performer{
        private String performerId;
        private String performerName;
    }
}
