package com.digiwin.athena.abt.application.dto.migration.atmc.im;

import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * IM群的UI实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ImTeamDTO {

    /**
     * 群主ID,EOC中的ID
     */
    private String owner;

    /**
     * 群名称
     */
    private String teamName;

    /**
     * 群Id
     */
    private String bizId;

    /**
     * 群类型
     */
    private ImTeamType teamType;

    /**
     * 是否是主群
     * 0-不是主群；1-主群
     */
    private int ifMaster;

    /**
     * 是否可见
     * 0-不可见；1-可见
     */
    private int visiable;

    /**
     * 群成员列表，EOC中的ID
     */
    private List<String> memberList;

    /**
     * 任务相关人员(EOC账户)
     */
    private List<Map> externalEocMembers;

    /**
     * 任务相关人员(IAM账户)
     */
    private List<Map> externalAccounts;

    /**
     * 任务关联的所属主项目群的Id
     */
    private String pId;

}
