package com.digiwin.athena.abt.application.dto.migration.atmc.parser;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.abt.application.dto.migration.atmc.bk.BkNode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * 目前MetadataUnit可以承载任务 项目 以及API所有的元数据信息，后续如果有差异性的数据处理，可由子类进行定制出处理
 *
 * @author zhangzhi@digiwin.com
 * @date 2021/12/3
 */
@Getter
@Setter
public class MetadataUnit {
    /** 下述都是基础属性,给予最红进行校验时候进行使用 */
    private String source;
    private String entityName;
    private Set<String> allJsonPath;
    private String shortestPath;
    private int shortestLength;
    private boolean isRoot;
    private Set<String> longestPath;
    /** 是否存在最长路径,如果所有路径通过.分割后长度都一致,此值为false */
    private boolean existLongest;
    /** 最长路径实例,简单保存处理,后续计算实例数据的时候需要使用 */
    private String pathInstance;
    /** bk属性名称与路径的映射关系 */
    private Map<String, BkNode> bkFields;

    public MetadataUnit(String source, String entityName, Map<String, BkNode> bkFields, boolean isRoot) {
        this.source = source;
        this.entityName = entityName;
        this.bkFields = bkFields;
        this.allJsonPath = new HashSet<>();
        bkFields.values().forEach(item -> allJsonPath.add(item.getNodePath()));
        this.shortestPath = getShortestPath(allJsonPath);
        this.shortestLength = shortestPath.split("\\.").length;
        this.isRoot = isRoot;

        List<String> tempLongestPath = listLongestJsonPath(allJsonPath);
        this.existLongest = CollectionUtil.isNotEmpty(tempLongestPath);
        if(existLongest){
            this.pathInstance = tempLongestPath.get(0);
        }else {
            this.pathInstance = this.allJsonPath.iterator().next();
        }
        this.longestPath = new HashSet<>(listLongestJsonPath(allJsonPath));
    }

    private String getShortestPath(Set<String> allJsonPath){
        String shortestPath = "";
        int shortestLength = 0;
        for(String jsonPath : allJsonPath){
            int tempLength = jsonPath.split("\\.").length;
            if(StringUtils.isEmpty(shortestPath)){
                shortestPath = jsonPath;
                shortestLength = tempLength;
            }
            if(shortestLength > tempLength){
                shortestLength = tempLength;
                shortestPath = jsonPath;
            }
        }
        return shortestPath;
    }

    private List<String> listLongestJsonPath(Set<String> allJsonPath){
        int maxLength = -1;
        MultiValueMap valueMap = new MultiValueMap();
        for(String jsonPath : allJsonPath){
            int tempLength = jsonPath.split("\\.").length;
            if(maxLength == -1){
                maxLength = tempLength;
            }
            if(maxLength < tempLength){
                maxLength = tempLength;
            }
            valueMap.put(String.valueOf(tempLength), jsonPath);
        }

        List<String> longest = (List<String>) valueMap.get(String.valueOf(maxLength));
        if(longest.size() == allJsonPath.size()){
            return new ArrayList<>();
        }

        return longest;
    }
}
