package com.digiwin.athena.abt.application.dto.migration.atmc.ptm;

import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class HttpAssistantServiceImpl {

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    public <T> T post(TypeReference<T> responseType, String url, HttpHeaders headers, Object body){

        T result = null;

        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<Object>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Object>>() {
            }, body);
            if(responseEntity.getBody().getResponseWithException("")!=null) {
                String json = JsonUtils.objectToString(responseEntity.getBody().getResponse());
                result = JsonUtils.jsonToObject(json, responseType);
            }
        }catch (ResourceAccessException e){
            BusinessException exception = BusinessException.create(e);
            exception.setCode(599);
            exception.setErrorCode(AtmcErrorCodeEnum.ATMC_OUTER_ACCESS_ERROR.getErrCode());
            exception.setErrorMessage(messageUtils.getMessage(AtmcErrorCodeEnum.ATMC_OUTER_ACCESS_NETWORK_ERROR.getErrCode()));
            exception.setDescription(getExceptionDescription(e.getMessage(), url, body));
            throw exception;
        }
        catch (Exception e){
            BusinessException exception = BusinessException.create(e);
            exception.setCode(599);
            exception.setErrorCode(AtmcErrorCodeEnum.ATMC_OUTER_ACCESS_NETWORK_ERROR.getErrCode());
            exception.setErrorMessage(messageUtils.getMessage(AtmcErrorCodeEnum.ATMC_OUTER_ACCESS_NETWORK_ERROR.getErrCode()));
            exception.setDescription(getExceptionDescription(e.getMessage(), url, body));
            throw exception;
        }
        return result;
    }

    private String getExceptionDescription(Object errorMessage, String url, Object body){
        Map description = new HashMap();
        description.put("uri", url);
        description.put("body", body);
        description.put("errorMessage", errorMessage);
        return JsonUtils.objectToString(description);
    }
}
