package com.digiwin.athena.abt.application.dto.migration.atmc.ptm;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.constants.BpmConstant;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogItemBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
@Slf4j
public class PtmBacklogTransformService {

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    /**
     * 是否启用了PTM
     *
     * @return
     */
    private boolean enablePTM() {
        return StringUtils.isNotBlank(envProperties.getPtmUri());
    }

    /**
     * 根据异常排除任务的 backlogId，查找未完成的任务数据<br>
     * 方便撤回
     *
     * @param backlogId
     * @return 没有数据，返回空数组
     */

    public List<Map> selectNoFinishedListByOriginBacklogIdForSolve(Long backlogId) {
        List<Map> result = new ArrayList<>();
        if (!enablePTM()) {
            return result;
        }

        List<Long> originalBacklogIds = new ArrayList<>();
        originalBacklogIds.add(backlogId);

        PtmBacklog ptmBacklog = commonPtmTransformService.getBacklogForCard(backlogId);
        if (ptmBacklog == null) {
            return result;
        }
        List<PtmBacklogItemBO> backlogItemList = ptmService.getBacklogByBacklogId(ptmBacklog.getBacklogId());
        backlogItemList.forEach(x -> originalBacklogIds.add(x.getWorkItemId()));
        List<Map> list = ptmService.getSolveTaskList(originalBacklogIds);
        log.info("getSolveTask list:{}", JsonUtils.objectToString(list));

        if (CollectionUtils.isNotEmpty(list)) {
            for (Map x : list) {
                if (x.containsKey("state") && MapUtils.getInteger(x, "state", 0) != 3) {
                    x.put("tm_task_id", x.get("projectDefCode"));
                    x.put("tm_activity_id", x.get("taskDefCode"));
                    x.put(BpmConstant.DATA_FROM_NAME, BpmConstant.DATA_FROM_PTM);
                    result.add(x);
                }
            }
        }
        return result;
    }

    /**
     * 获取回复型待办的 原始待办
     *
     * @param backlogId
     * @return
     */

    public PtmBacklog getReplyOriginalBacklog(Long backlogId) {
        PtmBacklog originaalBacklog = null;

        PtmBacklog backlog = ptmBacklogMapper.selectById(backlogId);
        if (backlog != null) {
            List<PtmBacklog> list = ptmBacklogMapper.selectByWorkItemId(backlog.getWorkItemId());
            if (CollectionUtils.isNotEmpty(list)) {
                for (PtmBacklog bl : list) {
                    if (Objects.equals(bl.getType(), 0)) {
                        originaalBacklog = bl;
                        break;
                    }
                }
            }
        }
        return originaalBacklog;
    }

}
