package com.digiwin.athena.abt.application.dto.migration.atmc.ptm;

import com.baomidou.mybatisplus.annotation.IEnum;

/**
 * PTM 消息对象类别枚举
 */
public enum PtmMqType implements IEnum<String> {

    /**
     * 项目卡(主项目)
     */
    projectCard("projectCard"),

    /**
     * 项目(子项目)
     */
    project("project"),

    /**
     * 任务卡
     */
    task("task"),

    /**
     * 工作项(包含活动+事项)的操作
     */
    workItem("workItem"),

    /**
     * 待办
     */
    backlog("backlog"),

    /**
     * 任务数据一致性
     */
    dataConsistency("dataConsistency"),

    /**
     * 知会
     */
    signInform("signInform"),

    /**
     * 流程引擎项目卡
     */
    flowProjectCard("flowProjectCard"),

    /**
     * 项目
     */
    flowProject("flowProject"),

    /**
     * 流程引擎待办
     */
    flowBacklog("flowBacklog"),

    /**
     * 流程引擎任务
     */
    flowWorkItem("flowWorkItem");

    private String _value;

    PtmMqType(String v){
        this._value = v;
    }

    @Override
    public String getValue() {
        return _value;
    }

}
