package com.digiwin.athena.abt.application.dto.migration.atmc.ptm;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * PTM 项目卡列表 的项目卡数据
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardItemDTO {

    /**
     * 项目卡id
     */
    private Long id;

    /**
     * 项目名称,指定语系返回
     */
    private String projectName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String projectWithName;

    /**
     * KM定义项目名称,指定语系返回
     */
    private String projectDefName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String projectDefWithName;

    /**
     * KM定义的项目编号
     */
    private String projectDefCode;

    /**
     * KM定义的项目pattern
     */
    private String projectDefPattern;

    /**
     * 项目卡计划开始时间
     */
    private LocalDateTime startTime;

    /**
     * 项目卡计划结束时间
     */
    private LocalDateTime endTime;

    /**
     * 项目卡创建时间
     */
    private LocalDateTime createTime;

    /**
     * 项目卡包含的紧急项目数量
     */
    private Integer emergencyProjectCount;

    /**
     * 项目卡包含的项目数量
     */
    private Integer projectCount;

    /**
     * 项目卡完成的项目数量
     */
    private Integer projectFinishedCount;

    /**
     * 当责者id
     */
    private String personInCharge;

    /**
     * 当责者name
     */
    private String personInChargeName;

    /**
     * 引擎类型，理论应该一直是 TaskEngine
     */
    private String engineType;

    /**
     * 正在进行中的待办数量
     */
    private Integer backlogCount;

    /**
     * 业务数据，项目卡的合并条件之一
     */
    private String mergeData;

    /**
     * 项目卡是否中断
     */
    private Boolean interrupt;

    /**
     * 项目卡是否转派
     */
    private Boolean reassign;

    /**
     * 项目卡是否交接
     */
    private Boolean handover;

    /**
     * 进行中的待办列表
     */
    private List<PtmBacklogRecordDTO> backlogs;

    /**
     * 来源处理者id
     */
    private String oldPerformerId;
    /**
     * 来源处理者姓名
     */
    private String oldPerformerName;

}
