package com.digiwin.athena.abt.application.dto.migration.atmc.ptm;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 权重响应对象
 *
 * @author lisheng
 * @date 2024/08/13
 * @since 1.0.0
 */
@Setter
@Getter
public class TaskActivityItemVO {
    /**
     * 所属任务卡待办id
     */
    private Long backlogId;
    /**
     * 活动关卡id
     */
    private Long activityId;
    /**
     * 处理者id
     */
    private String performerId;
    /**
     * 处理者姓名
     */
    private String performerName;
    /**
     * 任务、代办的执行人类型
     * 0 原执行人执行；1 代理人执行；2 辅助执行者执行；998 服务授权代理人执行；999 不作限制的外部执行者、超级管理员执行
     */
    private Integer performerType;
    /**
     * 代理者id
     */
    private String agentPerformerId;
    /**
     * 代理者姓名
     */
    private String agentPerformerName;
    /**
     * 事项来源
     * 0=正常产生/1=转派/2=退回重签/3=退回重办/4=加签/5=外部添加
     */
    private Integer createType;
    /**
     * 引擎事项id
     */
    private String workItemId;
    /**
     * 引擎前一事项id
     */
    private String fromWorkItemId;
    /**
     * 事项状态
     */
    private Integer state;
    /**
     * 事项子状态
     */
    private Integer subState;
    /**
     * 事项开始时间
     */
    private LocalDateTime createTime;
    /**
     * 事项结束时间
     */
    private LocalDateTime closedTime;

    /**
     * 合并的第一个事项id
     */
    private Long groupId;

    /**
     * 签核/提交意见
     */
    private String comment;

    /**
     * 任务id
     */
    private Long taskId;


    /**
     * 任务定义code
     */
    private String taskDefCode;

    /**
     * 引擎任务实例uid
     */
    private String bpmTaskUid;

    /**
     * TE task_data_item.data
     */
    private List<Map<String, Object>> dataItems;

    /**
     * TE task_data_item.uni_keys
     */
    private List<String> uniKeys;
}
