package com.digiwin.athena.abt.application.dto.migration.atmc.thememap;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

@Data
public class TmActivityPageDTO {

    private String title;
    private String subTitle;
    private String description;
    private String subDescription;

    private TmReasonDTO reason;

    private List<TmOperationDTO> operations;

    private String sourceType;

    private List<TmSummaryFieldDTO> summaryFields;

    /**
     * P4S1配置设计器结构page下面增加DataState
     * 数据状态列表，有几个状态，就显示几个页签
     */
    private List<TmDataState> dataStates;

    /**
     * 是否缓存summaryLayout，默认为true
     */
    private Boolean cardCache;

    /**
     * 是否可以转派，默认为false
     */
    private Boolean reassign = false;

    /**
     * 是否在标签也显示项目名称（taskName）
     */
    private Boolean showTaskNameInTab;

    /**
     * 项目卡通过API获取项目是否逾期时，API表示逾期的字段名
     */
    private String overduePropertyName;

    /**
     * 是否需要起定时任务刷新任务卡message
     */
    private Boolean scheduleRefreshCardMessage;

    /**
     * 刷新类型(默认 代表刷新所有) business(只刷新标签分组筛选排序)
     */
    private String scheduleRefreshCardType;
    /**
     * 新定时任务配置
     */
    private TmScheduleConfig scheduleConfig;
    /**
     * 是否调用查询uibot摘要接口 false 不查询
     */
    private Boolean enableQueryApi;


    /**
     * 在项目详情里增加配置subProjectQueryAction，可以配置api来获取关联的子项目的sourceid，然后平台根据sourceid获取到子项目列表。如果不配置，则默认根据当前项目id，关卡id去任务引擎查找从当前节点发起的子项目列表。
     */
    private SubProject subProject;

    @Data
    public static class SubProject {
        /**
         * 查询逻辑
         */
        private TmActionDTO queryAction;
        /**
         * 指定查询结果中子项目字段
         */
        private String sourceIdField;
        /**
         * 子项目在tm的code
         */
        private String subProjectCode;
    }

    /**
     * 根据dataStateType获取dataState
     * 兼容原逻辑，优先判断是否是原结构（type为空）
     *
     * @param dataStateTypes
     * @return
     */
    @JsonIgnore
    public TmDataState getDataStateByDataStateType(List<String> dataStateTypes) {
        TmDataState tmDataState = this.getDataStates().get(0);
        if (StringUtils.isBlank(tmDataState.getType())) {
            return tmDataState;
        }
        tmDataState = this.getDataStates().stream().filter(x -> dataStateTypes.contains(x.getType()) && CollectionUtils.isNotEmpty(x.getFieldMappings())).findFirst().orElse(new TmDataState());
        if (CollectionUtils.isNotEmpty(tmDataState.getFieldMappings())) {
            tmDataState.setSummaryFields(Lists.newArrayList());
            //转换结构
            tmDataState.getSummaryFields().addAll(convertSummaryFields(tmDataState.getFieldMappings()));
        }
        return tmDataState;
    }

    /**
     * 将fieldMappings转换成summaryFields
     *
     * @param fieldMappings
     * @return
     */
    private List<TmSummaryFieldDTO> convertSummaryFields(List<Map<String, Object>> fieldMappings) {
        List<TmSummaryFieldDTO> tmSummaryFieldDTOS = JsonUtils.jsonToListObject(JsonUtils.objectToString(fieldMappings), TmSummaryFieldDTO.class);
        tmSummaryFieldDTOS.forEach(x -> {
            x.setSummary(true);
        });
        return tmSummaryFieldDTOS;
    }
}
