package com.digiwin.athena.abt.application.dto.migration.atmc.thememap;

import com.digiwin.athena.abt.core.meta.constants.TmConstant;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.TmUserDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Data
public class TmActivityResponseDTO {

    private String activityId;
    private Object activityName;
    private int sequence;
    /**
     * 紧急
     */
    private int emergency;
    /**
     * 是否里程碑，true-在可视化面板显示，false-可视化面板不显示
     */
    private boolean milestone;
    private String executeType;
    private String pattern;
    private String category;
    private Object title;
    private Object subTitle;
    private Object description;
    private Object subDescription;
    private Boolean showFlow;
    private TmActivityExpectedDurationDTO expectedDuration;

    private Map<String, TmActionDTO> dataSources;

    private List<TmDataProcessDTO> dataProcessors;

    private int approveType;
    private int groupDispatchType;
    private List<String> startApproveActivity;
    private String startApproveActivityName;
    private Map lang;
    private List<Approves> approves;
    private List<Message> messages;

    /**
     * 任务逾期处理规则
     */
    private List<Map> overdueRules;

    /**
     * 汇总（已读，未读，已提交）
     */
    private TmCountItemDTO countItems;


    private TmActivityPageDTO pages;

    /**
     * 任务是否合并
     */
    private Boolean merge;

    /**
     * 任务可转派人员定义，没有定义表示可以转派给任意人员
     * <p>
     * 冲刺5开始，不再使用，请使用assignConfig
     */
    private TmUserDTO assignTo;

    /**
     * 任务的辅助执行者名单
     */
    private TmUserDTO assistant;

    /**
     * 是否可以转派
     * 为null或true，或没有指定，都表示可以转派
     * 为false表示不可以转派
     * <p>
     * 冲刺5开始，不再使用，请使用assignConfig
     */
    private Boolean assignAble = true;

    private String name;

    /**
     * 目标签核任务code
     */
    private String targetApproveActivity;

    /**
     * 卡片逾期时是否需要向辅助执行者发送新卡片
     */
    private boolean overdueAuxiliary;

    /**
     * 附加数据<br>
     * imGroup  是否创建im任务群，false不创建；null、true或没有此值，创建
     */
    private Map config;

    /**
     * 转派配置。同时兼容 assignAble 和 assignTo
     */
    private TmAssignConfigDTO assignConfig;

    /**
     * 附件配置
     */
    private TmAttachmentConfigInfo attachment;

    /**
     * inputData
     */
    private Map<String,Object> inputData;


    /**
     * xuxx
     * 移除外层的dataProcessors，移至：dataSources[x].dataProcessors
     * 如果同时存在以dataSources[x].中为准；
     */
    private void getNewDataProcessors() {
        //解决空指针问题
        Map<String, TmActionDTO> dateSourceMap = this.getDataSources();
        if (dateSourceMap == null) {
            return;
        }
        //xuxx 2022-11-07 移除外层的dataProcessors，移至：dataSources[x].dataProcessors,如果同时存在以dataSources[x].中为准；
        int indexProcess = 0;
        for (Map.Entry<String, TmActionDTO> stringTmQueryActionEntry : dateSourceMap.entrySet()) {
            String key = stringTmQueryActionEntry.getKey();
            TmActionDTO tmActionDTO = stringTmQueryActionEntry.getValue();
            if (!CollectionUtils.isEmpty(tmActionDTO.getDataProcessors())) {
                if (indexProcess == 0) {
                    dataProcessors = new ArrayList<>();
                }
                dataProcessors.addAll(tmActionDTO.getDataProcessors());
                indexProcess++;
            }
        }
    }

    /**
     * 是否存在CheckItems
     *
     * @return
     */
    @JsonIgnore
    public boolean hasCheckItems() {
        //重新解析dataProcessors
        getNewDataProcessors();
        return dataProcessors != null && dataProcessors.stream().filter(x -> TmConstant.CHECK_ITEM_SERVICE_NAME.equals(x.getServiceName())).findFirst().isPresent();
    }

    @JsonIgnore
    public TmDataProcessDTO getCheckItems() {
        //重新解析dataProcessors
        getNewDataProcessors();
        Optional<TmDataProcessDTO> optional = dataProcessors.stream().filter(x -> TmConstant.CHECK_ITEM_SERVICE_NAME.equals(x.getServiceName())).findFirst();
        return optional.orElseGet(optional::get);
    }

    /**
     * 是否存在CheckItems
     *
     * @return
     */
    @JsonIgnore
    public boolean hasCountItems() {
        //重新解析dataProcessors
        getNewDataProcessors();
        return dataProcessors != null && dataProcessors.stream().filter(x -> TmConstant.COUNT_ITEM_SERVICE_NAME.equals(x.getServiceName())).findFirst().isPresent();
    }

    /**
     * 是否存在SummaryFields
     *
     * @return
     */
    @JsonIgnore
    public boolean hasSummaryFields() {
        if (this.pages != null && !org.apache.commons.collections4.CollectionUtils.isEmpty(this.pages.getDataStates()) && this.pages.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = getDataStateByDataStateType("summary");
            if (dataState != null && !org.apache.commons.collections4.CollectionUtils.isEmpty(dataState.getSummaryFields())) {
                this.pages.setSummaryFields(dataState.getSummaryFields());
            }
        }
        return this.pages != null && !org.apache.commons.collections4.CollectionUtils.isEmpty(this.pages.getSummaryFields());
    }


    /**
     * 是否存在摘要字段
     *
     * @Author：SYQ
     * @Date：2022/10/21 10:39
     */
    @JsonIgnore
    public boolean existSummaryFields() {
        if (this.pages != null && !org.apache.commons.collections4.CollectionUtils.isEmpty(this.pages.getDataStates()) && this.pages.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = getDataStateByDataStateType("summary");
            if (dataState != null && !org.apache.commons.collections4.CollectionUtils.isEmpty(dataState.getSummaryFields())) {
                this.pages.setSummaryFields(dataState.getSummaryFields());
            }
        }
        if (this.pages == null || org.apache.commons.collections4.CollectionUtils.isEmpty(this.pages.getSummaryFields())) {
            return false;
        }
        List<TmSummaryFieldDTO> summaryList = this.pages.getSummaryFields().stream().filter(x -> (x.getSummary() == null || x.getSummary())).collect(Collectors.toList());
        return !org.apache.commons.collections4.CollectionUtils.isEmpty(summaryList);
    }

    /**
     * 是否存在operations
     *
     * @return
     */
    @JsonIgnore
    public boolean hasOperations() {
        return this.pages != null && !CollectionUtils.isEmpty(this.pages.getOperations());
    }

    /**
     * 是否要缓存summaryLayout
     *
     * @return
     */
    @JsonIgnore
    public boolean isCardCache() {
        if (this.pages != null && !org.apache.commons.collections4.CollectionUtils.isEmpty(this.pages.getDataStates()) && this.pages.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = getDataStateByDataStateType("summary");
            if (dataState != null) {
                this.pages.setCardCache(dataState.getCardCache());
            }
        }
        return this.pages != null && this.pages.getCardCache();
    }

    /**
     * 是否创建Im任务群
     *
     * @return
     */
    @JsonIgnore
    public boolean createImGroup() {
        boolean result = true;

        if (this.config != null && this.config.containsKey("imGroup") && this.config.get("imGroup") != null) {
            result = (boolean) this.config.get("imGroup");
        }

        return result;
    }

    /**
     * 根据dataStateType获取dataState
     * 兼容原逻辑，优先判断是否是原结构（type为空）
     *
     * @param dataStateType
     * @return
     */
    private TmDataState getDataStateByDataStateType(String dataStateType) {
        TmDataState tmDataState = pages.getDataStates().get(0);
        if (StringUtils.isBlank(tmDataState.getType())) {
            return tmDataState;
        }
        tmDataState = pages.getDataStates().stream().filter(x -> dataStateType.equals(x.getType())).findAny().orElse(null);
        if (tmDataState != null && org.apache.commons.collections4.CollectionUtils.isNotEmpty(tmDataState.getFieldMappings())) {
            tmDataState.setSummaryFields(Lists.newArrayList());
            //转换结构
            tmDataState.getSummaryFields().addAll(convertSummaryFields(tmDataState.getFieldMappings()));
        }
        return tmDataState;
    }

    /**
     * 将fieldMappings转换成summaryFields
     *
     * @param fieldMappings
     * @return
     */
    private List<TmSummaryFieldDTO> convertSummaryFields(List<Map<String, Object>> fieldMappings) {
        List<TmSummaryFieldDTO> tmSummaryFieldDTOS = JsonUtils.jsonToListObject(JsonUtils.objectToString(fieldMappings), TmSummaryFieldDTO.class);
        tmSummaryFieldDTOS.forEach(x -> {
            x.setSummary(true);
        });
        return tmSummaryFieldDTOS;
    }

    public static class Approves {

        private String key;
        private String identityType;
        private String identity;
        private List<Submits> submits;
        private String sequence;
        private String title;
        private int approveType;
        private String innerType;

        public Approves() {

        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return key;
        }

        public String getIdentityType() {
            return identityType;
        }

        public void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public void setIdentity(String identity) {
            this.identity = identity;
        }

        public String getIdentity() {
            return identity;
        }

        public void setSubmits(List<Submits> submits) {
            this.submits = submits;
        }

        public List<Submits> getSubmits() {
            return submits;
        }

        public void setSequence(String sequence) {
            this.sequence = sequence;
        }

        public String getSequence() {
            return sequence;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return title;
        }

        public void setApproveType(int approveType) {
            this.approveType = approveType;
        }

        public int getApproveType() {
            return approveType;
        }

        public void setInnerType(String innerType) {
            this.innerType = innerType;
        }

        public String getInnerType() {
            return innerType;
        }

    }

    public static class Submits {

        private String title;
        private String actionId;
        private String serviceName;
        private String type;
        private String innerType;

        public Submits() {

        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return title;
        }

        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public String getActionId() {
            return actionId;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return serviceName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return type;
        }

        public void setInnerType(String innerType) {
            this.innerType = innerType;
        }

        public String getInnerType() {
            return innerType;
        }

    }

    public class Message {

        private List<String> messageType;
        private List<ToUsers> toUsers;
        private String extractScript;
        private String title;
        private String content;
        private String contentType;

        public void setMessageType(List<String> messageType) {
            this.messageType = messageType;
        }

        public List<String> getMessageType() {
            return messageType;
        }

        public void setToUsers(List<ToUsers> toUsers) {
            this.toUsers = toUsers;
        }

        public List<ToUsers> getToUsers() {
            return toUsers;
        }

        public void setExtractScript(String extractScript) {
            this.extractScript = extractScript;
        }

        public String getExtractScript() {
            return extractScript;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return title;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return content;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return contentType;
        }

    }

    public class ToUsers {

        private String identityType;
        private String source;
        private String identity;

        public void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public String getIdentityType() {
            return identityType;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSource() {
            return source;
        }

        public void setIdentity(String identity) {
            this.identity = identity;
        }

        public String getIdentity() {
            return identity;
        }

    }
}
