package com.digiwin.athena.abt.application.dto.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class BatchImportListRespDTO {

    /**
     * 作业名称
     */
    private String name;

    /**
     * 最新上传时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date latestUploadTime;

    /**
     * 作业类型
     */
    private String type;

    /**
     * 作业场景
     */
    private String scene;


    /**
     * 作业id
     */
    private String activityId;

    /**
     * 导入配置
     */
    private List<ImportAction> importAction;

    /**
     * 模版配置
     */
    private TemplateAction templateAction;


    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ImportAction {

        /**
         * actionId
         */
        private String actionId;

        /**
         * type: insert,update,insertOrUpdate
         */
        private String actionType;

    }

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class TemplateAction {

        private String actionId;


    }

}