package com.digiwin.athena.abt.application.service.abt.migration.assembler;

import com.digiwin.athena.abt.application.dto.migration.abt.api.ActivityStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ErrorTableDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.ImportStatisticsDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.TableDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ActivityStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ErrorTable;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.Table;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @ClassName ImportStatisticsAssembler
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/12 11:28
 * @Version 1.0
 **/
public class ImportStatisticsAssembler {

    private static final List<ImportStatisticsDTO> emptyImportStatisticsDTOList = Collections.emptyList();

    public static List<ImportStatisticsDTO> importStatisticsListToDTO(List<ImportStatistics> importStatisticsList) {

        if (CollectionUtils.isEmpty(importStatisticsList)) {
            return emptyImportStatisticsDTOList;
        }
        List<ImportStatisticsDTO> importStatisticsDTOList = new LinkedList<>();
        importStatisticsList.forEach(item->{
            ImportStatisticsDTO importStatisticsDTO = new ImportStatisticsDTO();
            BeanUtils.copyProperties(item, importStatisticsDTO);
            importStatisticsDTOList.add(importStatisticsDTO);
        });
        return importStatisticsDTOList;

    }

    public static ErrorTableDTO errorTableToDTO(ErrorTable errorTable) {
        ErrorTableDTO errorTableDTO = new ErrorTableDTO();
        errorTableDTO.setData(errorTable.getData());
        errorTableDTO.setHeaders(errorTable.getHeaders());
        errorTableDTO.setErrorNum(errorTable.getErrorNum());
        errorTableDTO.setProcessingNum(errorTable.getProcessingNum());
        errorTableDTO.setSucceededNum(errorTable.getSucceededNum());
        errorTableDTO.setFailedNum(errorTable.getFailedNum());
        errorTableDTO.setActionId(errorTable.getActionId());
        errorTableDTO.setRepublished(errorTable.getRepublished());
        return errorTableDTO;
    }

    public static ImportStatisticsDTO toDTO(ImportStatistics importStatistics) {
        ImportStatisticsDTO importStatisticsDTO = new ImportStatisticsDTO();
        if (null == importStatistics) {
            return importStatisticsDTO;
        }
        BeanUtils.copyProperties(importStatistics, importStatisticsDTO);
        return importStatisticsDTO;
    }

    public static Table tableToDO(TableDTO tableDTO) {
        Table table = new Table();
        if (null == tableDTO) {
            return table;
        }
        BeanUtils.copyProperties(tableDTO, table);
        if (table.getHeaders() != null && !table.getHeaders().isEmpty()) {
            table.getHeaders().forEach(map -> {
                if (map.containsKey("headers")) {
                    map.put("key", ExcelUtil.getSheetNameInParens(map.get("key").toString()));
                }
            });
        }

        // <rowIndex, DFieldName>
        Map<Integer, String> rowDFieldMap = new HashMap<>();
        if (table.getData() != null && !table.getData().isEmpty()) {
            for (int i = 0; i < table.getData().size(); i++) {
                Map<String, Object> map = (Map<String, Object>) table.getData().get(i);
                for (String key : map.keySet()) {
                    if (map.get(key) instanceof List<?>) {
                        rowDFieldMap.put(i, key);
                    }
                }
            }
        }

        if (rowDFieldMap.size() > 0) {
            rowDFieldMap.forEach((rowIndex, DFieldName) -> {
                Object DFieldValue = table.getData().get(rowIndex).remove(DFieldName);
                table.getData().get(rowIndex).put(ExcelUtil.getSheetNameInParens(DFieldName), DFieldValue);
            });
        }

        return table;
    }

    public static ActivityStatisticsDTO activityStatisticsToDTO(ActivityStatistics activityStatistics) {
        return JsonUtils.jsonToObject(JsonUtils.objectToString(activityStatistics), ActivityStatisticsDTO.class);
    }
}
