package com.digiwin.athena.abt.application.service.abt.migration.bk;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.bk.ProjectBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmBackLogMsgDto;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmTaskTimelyMsgDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.ActivityBusinessKeyHandler;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.ProjectBusinessKeyHandler;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqManageMsgService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

import static com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmMqType.workItem;
import static com.digiwin.athena.abt.core.meta.constants.MessageTypeConstant.*;

@Slf4j
@Service
public class BusinessKeyMqService {

    @Autowired
    private PtmService ptmService;

    @Autowired
    private ProjectBusinessKeyHandler projectBusinessKeyHandler;

    @Autowired
    private ActivityBusinessKeyHandler activityBusinessKeyHandler;

    @Autowired
    private PtmTransformService ptmTransformService;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private MqManageMsgService mqManageMsgService;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;



    /**
     * 判断是项目的bk还是任务的bk
     * @param data
     */
    public void processBkMessage(String data, AuthoredUser user){
        log.info("BusinessKeyMqService.processBkMessage:{}",data);
        PtmDataConsistencyMessageDTO messageDTO = ActivityUtils.convertPtmDataConsistencyMsg(data);
        PtmDataConsistencyMessageDTO.MqData mqData = messageDTO.getData();
        PtmDataConsistencyMessageDTO.Project project = mqData.getProject();
        if(project != null){
            processProject(project, user);
        }else {
            List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = mqData.getWorkItem();
            if(CollectionUtils.isNotEmpty(workItemList)){
                AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
                Map<Long,List<PtmDataConsistencyMessageDTO.WorkItem>> backLogToWorkItem = Maps.newHashMap();
                for (PtmDataConsistencyMessageDTO.WorkItem workItem : workItemList) {
                    AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
                    processWorkItem(workItem, user);
                    List<PtmDataConsistencyMessageDTO.WorkItem> workItems = backLogToWorkItem.computeIfAbsent(workItem.getBacklogId(), e -> new ArrayList<>());
                    workItems.add(workItem);
                }
                AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
                try {
                    backLogToWorkItem.forEach((k,v)->{
                        PtmDataConsistencyMessageDTO.WorkItem workItem = v.get(0);
                        String isSend = sendBackLogRemindMsg(messageDTO,v.get(0),user);
                        if (SEND_YES.equals(isSend)){
                            log.info("发送催办消息，代办id:{},事项id:{}",workItem.getBacklogId(),workItem.getId());
                            // 发送任务（待办）强提醒-MQTT
                            sendTaskTimelyRemindMsg(messageDTO,workItem,user);
                        }
                    });
                }catch (Exception ex){
                    log.warn("发送弱提醒失败:{}",ex.getMessage(), ex);
                }
                AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            }
        }
    }

    /**
     * 发送任务（待办）弱提醒-工作提醒
     * @param messageDTO
     * @param user
     * @return
     */
    private String sendBackLogRemindMsg(PtmDataConsistencyMessageDTO messageDTO, PtmDataConsistencyMessageDTO.WorkItem workItem,AuthoredUser user) {
        QueryWrapper<PtmBacklog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("task_id", workItem.getTaskId());
        boolean canCreateTaskTeam = ptmBacklogMapper.selectCount(queryWrapper) <= 1;
        PtmBacklogRecordDTO backlogRecord = ptmService.getBacklogRecord(workItem.getBacklogId());
        log.info("查询backlogRecord结果：{}",backlogRecord);
        PtmBacklogMessageDTO.Backlog backlog = new PtmBacklogMessageDTO.Backlog();
        backlog.setBacklogId(workItem.getBacklogId());
        backlog.setProjectId(workItem.getProjectId());
        backlog.setProjectCardId(workItem.getProjectCardId());
        backlog.setTaskId(workItem.getTaskId());
        backlog.setName(backlogRecord.getName());
        backlog.setPerformerId(backlogRecord.getPerformerId());
        backlog.setPerformerName(backlogRecord.getPerformerName());
        PtmBackLogMsgDto ptmBackLogMsgDto = PtmBackLogMsgDto.builder()
                .authoredUser(user)
                .operation(messageDTO.getOperation())
                .backlog(backlog)
                .canCreateTaskTeam(canCreateTaskTeam)
                .minSplit(BooleanUtils.isTrue(backlogRecord.getCreatedFlag()))
                .messageType(WORKITEM_MESSAGE_TYPE_ADD)
                .workItemId(workItem.getId())
                .build();
        if (backlogRecord.getHidden()||!backlogRecord.getWorkItemId().equals(workItem.getId())){
            ptmBackLogMsgDto.setMessageType(WORKITEM_MESSAGE_TYPE_UPDATE);
            return SEND_NO;
        }
        mqManageMsgService.excutesendBackLogRemindMsg(ptmBackLogMsgDto);
        return SEND_YES;
    }

    /**
     * 发送任务（待办）强提醒-MQTT
     * @param messageDTO
     * @param user
     */
    private void sendTaskTimelyRemindMsg(PtmDataConsistencyMessageDTO messageDTO,PtmDataConsistencyMessageDTO.WorkItem workItem, AuthoredUser user) {
//        PtmDataConsistencyMessageDTO dataConsistencyMessageDTO = JsonUtils.jsonToObject(data, PtmDataConsistencyMessageDTO.class);
        Task task = ptmTransformService.translateProjectOrProjectCard(workItem.getProjectId());
        Backlog backlog = commonPtmTransformService.translateBacklogById(workItem.getBacklogId());
        log.info("【dataConsistencyMessage-timely-remind】：task：{}，backlog：{}", task, backlog);
        PtmTaskTimelyMsgDto ptmTaskTimelyMsgDto = new PtmTaskTimelyMsgDto();
        ptmTaskTimelyMsgDto.setTask(task);
        ptmTaskTimelyMsgDto.setBacklog(backlog);
        ptmTaskTimelyMsgDto.setOperation(messageDTO.getOperation());
        ptmTaskTimelyMsgDto.setAuthoredUser(user);
        mqManageMsgService.excuteSendTaskTimelyRemindMsg(ptmTaskTimelyMsgDto);
    }

    /**
     * PTM项目bk
     * @param project
     */
    public void processProject(PtmDataConsistencyMessageDTO.Project project, AuthoredUser user){
        PtmProjectRecordBO ptmProjectRecordBO = ptmService.getProjectRecord(project.getId());
        ProjectBusinessKeyDTO projectBusinessKeyDTO = new ProjectBusinessKeyDTO();
        projectBusinessKeyDTO.setId(project.getId());
        projectBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        projectBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        projectBusinessKeyDTO.setState(ptmProjectRecordBO.getState());
        projectBusinessKeyDTO.setSourceIds(ptmProjectRecordBO.getSourceIds());
        projectBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject(ptmProjectRecordBO.getBusinessUnit()));
        projectBusinessKeyDTO.setData(JSONObject.fromObject(ptmProjectRecordBO.getData()));
        projectBusinessKeyDTO.setAuthoredUser(user);
        projectBusinessKeyHandler.process(projectBusinessKeyDTO);

    }

    /**
     * PTM任务bk
     * @param workItem
     */
    private void processWorkItem(PtmDataConsistencyMessageDTO.WorkItem workItem, AuthoredUser user){
        // TODO 需要改造
        PtmTaskRecordBO ptmTaskRecordBO = ptmService.getTaskRecord(workItem.getTaskId(),workItem.getId());
        //
        PtmActivityRecordDTO ptmActivityRecordDTO = ptmService.getActivityRecord(workItem.getActivityId());
        PtmProjectRecordBO ptmProjectRecordBO = ptmService.getProjectRecord(workItem.getProjectId());

        ActivityBusinessKeyDTO activityBusinessKeyDTO = new ActivityBusinessKeyDTO();
        activityBusinessKeyDTO.setSubTaskId(ptmProjectRecordBO.getId());
        activityBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        activityBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        activityBusinessKeyDTO.setState(ptmActivityRecordDTO.getState());
        activityBusinessKeyDTO.setActivityId(workItem.getActivityId());
        activityBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject(ptmTaskRecordBO.getBusinessUnit()));
        activityBusinessKeyDTO.setData(JSONObject.fromObject(ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setTmActivityId(ptmTaskRecordBO.getTaskDefCode());
        activityBusinessKeyDTO.setBpmData(JSONObject.fromObject(ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setWorkitemId(workItem.getId());
        activityBusinessKeyDTO.setClosed(ptmActivityRecordDTO.getState() >= 3);
        activityBusinessKeyDTO.setAuthoredUser(user);
        activityBusinessKeyHandler.process(activityBusinessKeyDTO);
    }

    /**
     * 流程引擎项目bk
     * @param data
     */
    public void processFlowProjectBk(String data, AuthoredUser user){
        ProjectBusinessKeyDTO projectBusinessKeyDTO = JsonUtils.jsonToObject(data, ProjectBusinessKeyDTO.class);
        projectBusinessKeyDTO.setAuthoredUser(user);
        projectBusinessKeyHandler.process(projectBusinessKeyDTO);
    }

    /**
     * 流程引擎任务bk
     * @param data
     */
    public void processFlowBacklogBk(String data, AuthoredUser user){
        ActivityBusinessKeyDTO activityBusinessKeyDTO = JsonUtils.jsonToObject(data, ActivityBusinessKeyDTO.class);
        activityBusinessKeyDTO.setAuthoredUser(user);
        activityBusinessKeyHandler.process(activityBusinessKeyDTO);
    }

}
