package com.digiwin.athena.abt.application.service.abt.migration.bk;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.core.meta.constants.EventModelConstants;
import com.digiwin.athena.abt.core.meta.constants.EventMqConstants;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * 事件-项目卡/任务卡BK模版
 */
@Slf4j
@Service
public class EventBkMessageModel extends EventBaseService implements EventInterface {

    @Autowired
    private BusinessKeyMqService businessKeyMqService;

    /**
     * 支持消息类型
     *
     * @return
     */
    @Override
    public String modelType() {
        return EventModelConstants.BUSINESS_KEY_MODEL;
    }

    /**
     * 分发消息
     *
     * @param
     * @param data
     */
    @Override
    public void distributeMessages(String data) {
        rabbitTemplate.convertAndSend(EventMqConstants.EVENT_MQ_EXCHANGE_NAME, EventMqConstants.EVENT_MQ_BUSINESS_KEY_ROUTING, data);
    }

    /**
     * 消费消息
     *
     * @param data
     */
    @Override
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_MQ_BUSINESS_KEY_QUEUE, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_MQ_BUSINESS_KEY_ROUTING
    ), concurrency = "#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('" + EventMqConstants.EVENT_MQ_BUSINESS_KEY_QUEUE + "')}")
    @RabbitRetry(beforeHandler = "ptmMqBeforeHandler", successHander = "ptmMqSuccessHandler", failureHandler = "ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag, @Header(value = "retry-count", required = false) Integer retryCount) {
        super.receiveOrder(data, EventMqConstants.EVENT_MQ_BUSINESS_KEY_QUEUE, channel, tag, retryCount);
    }

    /**
     * 重写：处理mq消息
     */
    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        if (EventMqTypeEnum.dataConsistency.equals(mqMessageDTO.getType())) {
            businessKeyMqService.processBkMessage(data, user);
        } else if (EventMqTypeEnum.flowProject.equals(mqMessageDTO.getType())) {
            businessKeyMqService.processFlowProjectBk(data, user);
        } else if (EventMqTypeEnum.flowWorkItem.equals(mqMessageDTO.getType())) {
            businessKeyMqService.processFlowBacklogBk(data, user);
        }
    }
}
