package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Locale;

@Slf4j
@Service
public class EventBaseService {

    @Autowired
    protected RabbitTemplate rabbitTemplate;

    @Autowired
    protected EnvProperties envProperties;

    /**
     * 接收消息后处理
     *
     * @param data
     * @param queueName
     * @param channel
     * @param tag
     * @throws IOException
     */
    public void receiveOrder(String data, String queueName, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag, @Header(value = "retry-count", required = false) Integer retryCount) {
        log.info("[athena.event.message.abt-data]: queueName = {} , processMessage data = {}", queueName, data);
        try {
            // 获取语言别
            if ("TRADITIONAL_CHINESE".equals(envProperties.getDefaultLanguage())) {
                LocaleContextHolder.setLocale(Locale.TRADITIONAL_CHINESE);
            } else {
                LocaleContextHolder.setLocale(Locale.SIMPLIFIED_CHINESE);
            }
            // 获取操作类型
            EventListenerDTO eventListenerDTO = JsonUtils.jsonToObject(data, EventListenerDTO.class);
            //处理token
            getUser(eventListenerDTO);
            // 处理消息
            processMessage(data, eventListenerDTO);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * 处理mq消息
     */
    public void processMessage(String data, EventListenerDTO eventListenerDTO) {

    }


    /**
     * 获取用户信息
     *
     * @param mqMessageDTO
     * @return
     */
    public AuthoredUser getUser(EventListenerDTO mqMessageDTO) {
        if (null == mqMessageDTO.getUser() && null == mqMessageDTO.getFlowUser()) {
            return null;
        }
        AuthoredUser user = new AuthoredUser();
        if (null != mqMessageDTO.getUser()) {
            user.setSid(mqMessageDTO.getUser().getUserSid());
            user.setUserId(mqMessageDTO.getUser().getUserId());
            user.setUserName(mqMessageDTO.getUser().getUserName());
            user.setTenantSid(mqMessageDTO.getUser().getTenantSid());
            user.setTenantId(mqMessageDTO.getUser().getTenantId());
            user.setTenantName(mqMessageDTO.getUser().getTenantName());
            user.setToken(mqMessageDTO.getUser().getToken());
        } else {
            user = mqMessageDTO.getFlowUser();
        }
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        return user;
    }
}
