package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.core.meta.constants.EventModelConstants;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

import static com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum.backlog;

/**
 * 事件监听
 */
@Slf4j
@Service
public class EventListenerService {

    @Autowired
    private EventModelService eventModelService;

    /**
     * 处理消息
     *
     * @param data
     * @param eventListenerDTO
     */
    public void processMsg(String data, EventListenerDTO eventListenerDTO) {
        // 模板类型
        List<String> eventModelTypeList = new ArrayList<>();
        // 根据消息类型整合事件模板
        switch (eventListenerDTO.getType()) {
            case backlog: // NOSONAR
                if (PtmMqOperation.OVERDUE.equals(eventListenerDTO.getOperation())) {
                    eventModelTypeList.add(EventModelConstants.TASK_OPERATE_SEND_MSG_MODEL);
                }
            case projectCard: // NOSONAR
                eventModelTypeList.add(EventModelConstants.CARD_MQTT_MODEL);
            case flowProjectCard:
                // 2、云信群聊
                eventModelTypeList.add(EventModelConstants.GROUP_TEAM_MODEL);
                // 1、项目卡/任务卡的摘要、搜索项、历史资讯
                if (PtmMqOperation.ADD.equals(eventListenerDTO.getOperation())) {
                    eventModelTypeList.add(EventModelConstants.BUSINESS_MESSAGE_MODEL);
                }
                break;
            case dataConsistency: // NOSONAR
                if (PtmMqOperation.ADD.equals(eventListenerDTO.getOperation())) {
                    eventModelTypeList.add(EventModelConstants.TASK_OPERATE_SEND_MSG_MODEL);
                }
            case flowWorkItem:
                // 3、业务主键
                eventModelTypeList.add(EventModelConstants.BUSINESS_KEY_MODEL);
                // 1、项目卡/任务卡的摘要、搜索项、历史资讯
                if (PtmMqOperation.ADD.equals(eventListenerDTO.getOperation())) {
                    eventModelTypeList.add(EventModelConstants.BUSINESS_MESSAGE_MODEL);
                }
                break;
            case task:
            case project:
            case flowBacklog:
                // 2、云信群聊
                eventModelTypeList.add(EventModelConstants.GROUP_TEAM_MODEL);
                break;
            case flowProject:
                // 3、业务主键
                eventModelTypeList.add(EventModelConstants.BUSINESS_KEY_MODEL);
                // 2、云信群聊
                eventModelTypeList.add(EventModelConstants.GROUP_TEAM_MODEL);
                break;
            default:
        }
        // 分发消息
        log.info("[athena.event.message.abt-data]: processMessage eventModelTypeList = {}", JsonUtils.objectToString(eventModelTypeList));
//        LogDto logDto = new LogDto("【EventListenerService】分发event消息，eventModelTypeList：" + JsonUtils.objectToString(eventModelTypeList), eventListenerDTO.getUser().getTenantId());
//        log.info(logDto.toString());
        for (String eventModelType : eventModelTypeList) {
            eventModelService.getTargetModel(eventModelType).distributeMessages(data);
        }
    }

}
