package com.digiwin.athena.abt.application.service.abt.migration.event;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 计算不同事件需使用的模板
 */
@Component
public class EventModelService implements ApplicationContextAware {
    // 模板集合
    private Map<String, EventInterface> modelMap = new ConcurrentHashMap<>();

    /**
     * 初始化事件模板
     * @param applicationContext
     * @throws BeansException
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, EventInterface> tempMap = applicationContext.getBeansOfType(EventInterface.class);
        tempMap.values().forEach(source -> modelMap.put(source.modelType(), source));
    }

    /**
     * 获取目标模板
     * @param modelType
     * @return
     */
    public EventInterface getTargetModel(String modelType){
        return Optional.ofNullable(modelMap.get(modelType))
                .orElseThrow(() -> new IllegalArgumentException("Event model acquisition failed"));
    }


}
