package com.digiwin.athena.abt.application.service.abt.migration.event;

import com.digiwin.athena.abt.application.dto.migration.abt.event.ExportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.ImportSuccessEvent;
import com.digiwin.athena.abt.application.dto.migration.abt.event.MessageFactory;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.PersonalCenterMessage;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;

/**
 * @ClassName EventPublisher
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/9 10:57
 * @Version 1.0
 **/
@Slf4j
@Service
public class EventPublisher {

    @Resource
    RestTemplate amiRestTemplate;

    @Autowired
    AimService aimService;

    @Value("${aim.uri}")
    private String aimUrl;

    @Value("${athena.auth.appToken}")
    private String appToken;

    private final String aimSendUrl = "/api/aim/v1/message";

    public void publish(ImportSuccessEvent event) {
        //消息中心
        try {
            pushToMessageCenter(event);
        } catch (Exception e) {
            log.error("发送个人中心消息失败",e);
        }
        //消息弹框
        try {
            MessageDO messageDO = JsonUtils.jsonToObject(event.getUserJson(), MessageDO.class);
            messageDO.setContent(event);
            messageDO.setCategory("ATHENA_REMIND");
            messageDO.setSendDate(LocalDateTime.now());
            messageDO.setGid(event.getId());
            messageDO.setType("baseDataEntry");
            messageDO.setSubType(ImportAndExportStatisticsConstants.MESSAGE_SUB_TYPE_IMPORT);
            String token = getSecurityToken(event.getUserToken());
            aimService.sendMessageToClient(token,messageDO.getTenantId(), Arrays.asList(messageDO.getUserId()),messageDO);
        } catch (Exception e) {
            log.error("发送推送消息失败",e);
        }
    }

    /**
     * 发送导出文件MQTT消息
     * @param event
     */
    public void publish(ExportSuccessEvent event) {
        //消息中心 —— 异步导出暂不发送消息提醒
//        try {
//            pushToMessageCenter(event);
//        } catch (Exception e) {
//            log.error("发送个人中心消息失败",e);
//        }
        //消息弹框
        try {
            MessageDO messageDO = JsonUtils.jsonToObject(event.getUserJson(), MessageDO.class);
            messageDO.setContent(event);
            messageDO.setCategory("ATHENA_REMIND");
            messageDO.setSendDate(LocalDateTime.now());
            messageDO.setGid(event.getId());
            messageDO.setType("baseDataEntry");
            messageDO.setSubType(ImportAndExportStatisticsConstants.MESSAGE_SUB_TYPE_EXPORT);

            String token = getSecurityToken(event.getUserToken());
            aimService.sendMessageToClient(token,messageDO.getTenantId(), Arrays.asList(messageDO.getUserId()),messageDO);
        } catch (Exception e) {
            log.error("发送推送消息失败",e);
        }
    }

    private void pushToMessageCenter(ImportSuccessEvent event) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(event.getUserToken());
        } catch (Exception e) {
            log.error("解析token失败:{}", event.getUserToken());
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0072.getErrCode(),"解析token失败", e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        headers.add("digi-middleware-auth-user", dwSecurityContext.getUserToken());
        headers.add("digi-middleware-auth-app", appToken);
        PersonalCenterMessage webSocketMessage = MessageFactory.producePcMsgByImportSuccessEvent(event);
        HttpEntity<PersonalCenterMessage> httpEntity = new HttpEntity<>(webSocketMessage, headers);
        String url = aimUrl + aimSendUrl;
        ResponseEntity<HashMap> responseEntity = amiRestTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class);
        if (responseEntity.getBody() != null) {
            HashMap result = responseEntity.getBody();
            if (result.get("status") != null) {
                String code = result.get("status").toString();
                if (!"200".equals(code)) {
                    log.error("发送消息推送失败");
                }
            }
        } else {
            log.error("发送消息推送失败");
        }
    }

    /**
     *
     * @param token
     * @return
     * @throws Exception
     */
    private String getSecurityToken(String token) throws Exception{
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(token);
            DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
            return dwSecurityContext.getUserToken();
        } catch (Exception e) {
            log.error("解析token失败:{}", token);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0072.getErrCode(),"解析token失败", e);
        }
    }

    private void pushToMessageCenter(ExportSuccessEvent event) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        DWSecurityToken dwSecurityToken;
        try {
            dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(event.getUserToken());
        } catch (Exception e) {
            log.error("解析token失败:{}", event.getUserToken());
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0072.getErrCode(),"解析token失败", e);
        }
        DWSecurityContext dwSecurityContext = dwSecurityToken.getContext();
        headers.add("digi-middleware-auth-user", dwSecurityContext.getUserToken());
        headers.add("digi-middleware-auth-app", appToken);
        PersonalCenterMessage webSocketMessage = MessageFactory.producePcMsgByExportSuccessEvent(event);
        HttpEntity<PersonalCenterMessage> httpEntity = new HttpEntity<>(webSocketMessage, headers);
        String url = aimUrl + aimSendUrl;
        ResponseEntity<HashMap> responseEntity = amiRestTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class);
        if (responseEntity.getBody() != null) {
            HashMap result = responseEntity.getBody();
            if (result.get("status") != null) {
                String code = result.get("status").toString();
                if (!"200".equals(code)) {
                    log.error("发送消息推送失败");
                }
            }
        } else {
            log.error("发送消息推送失败");
        }
    }
}
