package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.ActivityUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.DataUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BkTaskActivityService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ActivityBusinessKeyHandler {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private BusinessKeyService businessKeySercvice;

    @Autowired
    private IParser iParser;

    @Autowired
    private BkTaskActivityService bkTaskActivityService;

    //消息队列名称
    private final String TASK_QUEUE = "DC_TASK_QUEUE";
    //交换机
    private final String TASK_EXCHANGE = "DC_TASK_EXCHANGE";

    private final String TASK_ROUTER_KEY = "DC_TASK_ROUTER_KEY";

    public void process(ActivityBusinessKeyDTO event) {
        try {
            processEvent(event);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(ActivityBusinessKeyDTO businessKeyDTO) {
        //token
        AuthoredUser authoredUser = businessKeyDTO.getAuthoredUser();
        //将token放入线程内
        if (null != authoredUser) {
            AppAuthContext appAuthContext = new AppAuthContext();
            appAuthContext.setAuthoredUser(authoredUser);
            AppAuthContextHolder.setContext(appAuthContext);
        }
        //向mq内推送消息
        ActivityUniformityMqDTO activityDataUniformityMqDTO = senMqToSd(businessKeyDTO);
        //数据一致性定义的bk值集合
        if (!businessKeyDTO.getClosed()) {
            dealDataUniformity(businessKeyDTO, authoredUser, activityDataUniformityMqDTO);
        }
    }

    public void processEventForRepair(ActivityBusinessKeyDTO businessKeyDTO) {
        //token
        AuthoredUser authoredUser = businessKeyDTO.getAuthoredUser();
        //将token放入线程内
        if (null != authoredUser) {
            AppAuthContext appAuthContext = new AppAuthContext();
            appAuthContext.setAuthoredUser(authoredUser);
            AppAuthContextHolder.setContext(appAuthContext);
        }
        //向mq内推送消息
        ActivityUniformityMqDTO activityDataUniformityMqDTO = senMqToSd(businessKeyDTO);
        //数据一致性定义的bk值集合
        if (!businessKeyDTO.getClosed()) {
            dealDataUniformity(businessKeyDTO, authoredUser, activityDataUniformityMqDTO);
        }
    }

    /**
     * 向mq内推消息
     *
     * @Author：SYQ
     * @Date：2022/5/27 14:38
     */
    private ActivityUniformityMqDTO senMqToSd(ActivityBusinessKeyDTO businessKeyDTO) {
        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
        dataUniformityMqDTO.setBusinessUnit(businessKeyDTO.getBusinessUnit());
        dataUniformityMqDTO.setProcessVar(businessKeyDTO.getData());

        ActivityUniformityMqDTO activityDataUniformityMqDTO = ActivityUniformityMqDTO.builder()
                .tenantId(businessKeyDTO.getTenantId())
                .state(businessKeyDTO.getState())
                .activityId(businessKeyDTO.getActivityId().toString())
                .activityTemplateId(businessKeyDTO.getTmActivityId())
                .subTaskTemplateId(businessKeyDTO.getTmTaskId())
                .subTaskId(businessKeyDTO.getSubTaskId().toString())
                .type("activity")
                .messageData(dataUniformityMqDTO)
                .build();

        //将任务数据推入MQ内
        rabbitTemplate.convertAndSend(TASK_EXCHANGE, TASK_ROUTER_KEY, JsonUtils.objectToString(activityDataUniformityMqDTO));
        log.info("任务消息队列：{}", JsonUtils.objectToString(activityDataUniformityMqDTO));
        return activityDataUniformityMqDTO;
    }

    /**
     * 数据一致性
     *
     * @Author：SYQ
     * @Date：2022/1/6 10:26
     */
    private List<JSONObject> dealDataUniformity(ActivityBusinessKeyDTO businessKeyDTO, AuthoredUser authoredUser, ActivityUniformityMqDTO activityDataUniformityMqDTO) {
        /*记录BK、项目卡的关联关系 start*/
        //是否存在数据一致性的bk，默认不存在
        boolean hasDataUniformityBk = false;
        //数据一致性的bk
        List<JSONObject> bkList = new ArrayList<>();
        try {
            //获取businessKey
            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject(activityDataUniformityMqDTO));
            List<ParserBo> parserBoList = iParser.parse(taskEvent, authoredUser);
            //将businessKey转为字符串
            if (!CollectionUtils.isEmpty(parserBoList)) {
                //存在数据一致性的bk
                hasDataUniformityBk = true;
                //获取bk内容
                for (ParserBo parserBo : parserBoList) {
                    bkList.add(parserBo.getBkInfo());
                }
                //记录BusinessKey和项目卡/任务卡的关联关系
                businessKeySercvice.insertBkTaskActivity(parserBoList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
            }
        } catch (Exception e) {
            log.warn("【获取数据一致性bk失败】：{}, {}", businessKeyDTO.getWorkitemId(), e);
        }

        //不存在数据一致性bk时，获取TM中定义的bk
        if (!hasDataUniformityBk) {
            //themMap中定义的bk值集合
            Map<String, Object> bkMap = bkTaskActivityService.getTmBusinessKeyNew(businessKeyDTO.getTmTaskId(), businessKeyDTO.getTmActivityId(), businessKeyDTO.getBpmData());
            //复杂结构的bk
            List<JSONObject> bkValueList = new ArrayList<>();
            if (bkMap.containsKey("complex")) {
                bkValueList = JSONArray.fromObject(bkMap.get("complex"));
            }
            //简单结构的bk
            List<Object> bkObjectValueList = new ArrayList<>();
            if (bkMap.containsKey("simple")) {
                bkObjectValueList = JSONArray.fromObject(bkMap.get("simple"));
            }
            //记录BusinessKey和项目卡/任务卡的关联关系
            bkTaskActivityService.insertOriBk(bkValueList, bkObjectValueList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
        }

        /*记录BK、项目卡的关联关系 end*/
        return bkList;
    }
}
