package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.bk.ProjectBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.DataUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.TaskUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class ProjectBusinessKeyHandler {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private BusinessKeyService businessKeyService;

    @Autowired
    private IParser iParser;

    //消息队列名称
    private final String TASK_QUEUE = "DC_TASK_QUEUE";
    //交换机
    private final String TASK_EXCHANGE = "DC_TASK_EXCHANGE";

    private final String TASK_ROUTER_KEY = "DC_TASK_ROUTER_KEY";

    public void process(ProjectBusinessKeyDTO event) {
        try {
            processEvent(event);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    private void processEvent(ProjectBusinessKeyDTO businessKeyDTO) {
        /*整理推入MQ的消息内容 start*/
        TaskUniformityMqDTO taskDataUniformityMqDTO = new TaskUniformityMqDTO();
        taskDataUniformityMqDTO.setTenantId(businessKeyDTO.getTenantId());
        taskDataUniformityMqDTO.setState(businessKeyDTO.getState());
        taskDataUniformityMqDTO.setSubTaskTemplateId(businessKeyDTO.getTmTaskId());
        taskDataUniformityMqDTO.setSubTaskId(businessKeyDTO.getId().toString());
        taskDataUniformityMqDTO.setType("task");
        taskDataUniformityMqDTO.setSourceIds(businessKeyDTO.getSourceIds());

        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
        dataUniformityMqDTO.setBusinessUnit(businessKeyDTO.getBusinessUnit());
        dataUniformityMqDTO.setProcessVar(businessKeyDTO.getData());
        taskDataUniformityMqDTO.setMessageData(dataUniformityMqDTO);

        //将项目数据推入MQ内
        rabbitTemplate.convertAndSend(TASK_EXCHANGE, TASK_ROUTER_KEY, JsonUtils.objectToString(taskDataUniformityMqDTO));
        log.info("项目消息队列：{}", JsonUtils.objectToString(taskDataUniformityMqDTO));
        /*整理推入MQ的消息内容 end*/

        /*记录BK、项目卡的关联关系 start*/
        try {
            //获取businessKey
            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject(taskDataUniformityMqDTO));
            List<ParserBo> parserBoList = iParser.parse(taskEvent, businessKeyDTO.getAuthoredUser());
            //将businessKey转为字符串
            List<JSONObject> bkList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(parserBoList)) {
                for (ParserBo parserBo : parserBoList) {
                    bkList.add(parserBo.getBkInfo());
                }
                //记录BusinessKey和项目卡/任务卡的关联关系
                businessKeyService.insertBkTaskActivity(parserBoList, businessKeyDTO.getId(), businessKeyDTO.getTenantId(), "task");
            }
        } catch (Exception e) {
            log.warn("获取项目bk失败,businessKeyDTO:{},{}:", JsonUtils.objectToString(businessKeyDTO),e);
        }
        /*记录BK、项目卡的关联关系 end*/
    }
}
