package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmBacklogCreateGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.im.ImBpmActivityTeamDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardDetailDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmTaskCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

/**
 * PTM 待办创建后，创建 或 更新 IM任务群
 * 业务逻辑复制至 TaskEngineActivityHandleService.processActivityStep
 */
@Slf4j
@Service
public class PtmBacklogCreateGroupHandler {

    @Autowired
    private TeamMemberService teamMemberService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private UserService userService;

    public void process(PtmBacklogCreateGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        } catch (Exception ex) {
            log.warn("PTM 创建或更新 IM任务群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), event);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * @param backlog
     */
    private void processEvent(PtmBacklogCreateGroupDTO backlog) {
        AuthoredUser authoredUser = backlog.getAuthoredUser();

        log.info("【PtmBacklogCreateGroupSubscriber-event】：{}", backlog);
        if (authoredUser == null) {
            return;
        }

        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

        // 设置语言别
        String userLangName = userService.getUserLangNameByUserId(authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());
        Locale locale = LocaleUtils.toLocale(userLangName);
        LocaleContextHolder.setLocale(locale);


        if (PtmMqOperation.ADD.equals(backlog.getOperation()) && Objects.equals(backlog.getCanCreateTaskTeam(), true)) {
            PtmProjectCardDetailDTO projectCard = ptmService.getProjectCardDetail(backlog.getProjectCardId());
            TmActivityResponseDTO tmActivityResponseDTO = themeMapService.getActivityAction(projectCard.getProjectDefCode(), backlog.getTaskDefCode(), TmPageName.TASK_CARD_NAME.getValue());
            log.info("【PtmBacklogCreateGroupSubscriber-tmActivityResponseDTO】：{}", tmActivityResponseDTO);
            if (!tmActivityResponseDTO.createImGroup()) {
                //不创建IM群
                return;
            }
            List<String> relatedUserList = null;
            int isExternal = 0;
            String plan = null;
            String businessKey = null;

            List<PtmTaskCardDataDTO> taskCardDataList = ptmService.getTaskDataByBacklogId(backlog.getBacklogId(), "data");
            if (CollectionUtils.isNotEmpty(taskCardDataList)) {
                businessKey = MapUtils.getString(taskCardDataList.get(0).getData(), "imBusinessKey");
            }

            List<ImBpmActivityTeamDTO.Performer> performerList = new ArrayList<>();
            ImBpmActivityTeamDTO.Performer performer = ImBpmActivityTeamDTO.Performer.builder()
                    .performerId(backlog.getPerformerId())
                    .performerName(backlog.getPerformerName())
                    .build();
            performerList.add(performer);

            ImBpmActivityTeamDTO teamDTO = ImBpmActivityTeamDTO.builder()
                    .bpmActivityId(backlog.getTaskId())
                    .tmActivityName(StringUtils.isEmpty(backlog.getTaskName()) ? backlog.getTaskDefName() : backlog.getTaskName())
                    .bpmActivityPlanEndTime(backlog.getPlanEndTime())
                    .performerList(performerList)
                    .relatedUserList(relatedUserList)
                    .isExternal(isExternal)
                    .plan(plan)
                    .tenantSid(String.valueOf(authoredUser.getTenantSid()))
                    .tenantName(authoredUser.getTenantName())
                    .imBusinessKey(businessKey)
                    .mainTaskId(backlog.getProjectCardId())
                    .mainTaskPersonInCharge(projectCard.getPersonInCharge())
                    .mainTaskPersonInChargeName(projectCard.getPersonInChargeName())
                    .build();
            log.info("【PtmBacklogCreateGroupSubscriber-createTeam-teamDTO】：{}", teamDTO);
            teamMemberService.createBpmActivityTeam(teamDTO, authoredUser);
        } else {
            List<String> addMemberList = new ArrayList<>();
            addMemberList.add(backlog.getPerformerId());
            log.info("【PtmBacklogCreateGroupSubscriber-addTeamMember】backlog：{}，addMemberList：{}", backlog, addMemberList);
            teamMemberService.addBpmActivityTeamMember(authoredUser, backlog.getTaskId(), addMemberList);
        }

    }
}
