package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectCardGroupDTO;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * PTM 创建项目卡后，创建IM项目群
 * 业务逻辑复制至 TaskEngineProjectServiceImpl.createProcess
 */
@Slf4j
@Service
public class PtmProjectCardCreateGroupHandler {

    @Autowired
    private TeamMemberService teamMemberService;

    public void process(PtmProjectCardGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        } catch (Exception ex) {
            log.warn("PTM新建项目卡时创建IM项目群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), event);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * @param content
     */
    private void processEvent(PtmProjectCardGroupDTO content) {
        AuthoredUser authoredUser = content.getAuthoredUser();
        if (authoredUser == null
                || !PtmMqOperation.ADD.equals(content.getOperation())) {
            return;
        }

        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

        Task task = Task.builder()
                .id(content.getId())
                .mainTaskId(content.getId())
                .name(content.getProjectName())
                .startTime(content.getStartTime())
                .endTime(content.getEndTime())
                .personInCharge(content.getPersonInCharge())
                .build();
        List<String> relatedUsers = content.getRelatedUsers();
        //取业务主键
        String businessKey = StringUtils.EMPTY;
        if(StringUtils.isNotEmpty(content.getImBusinessKey())){
            businessKey = content.getImBusinessKey();
        }
        teamMemberService.createTaskTeam(task, authoredUser, relatedUsers, businessKey);

    }
}
