package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectCardGroupDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * PTM 项目卡完成后，解散项目群及其所属的所有任务群
 * 业务逻辑复制至 TaskEngineProjectServiceImpl.updateProcessState
 */
@Slf4j
@Service
public class PtmProjectCardDeleteGroupHandler{

    @Autowired
    private ImService imService;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    public void process(PtmProjectCardGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        }catch (Exception ex){
            log.warn("PTM项目卡结束时解散IM项目群 error:{}, stack:{}，event:{}" ,ex, ex.getStackTrace(), event);
        }finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * @param content
     */
    private void processEvent(PtmProjectCardGroupDTO content) {
        AuthoredUser authoredUser = content.getAuthoredUser();
        if (authoredUser == null || !PtmMqOperation.CLOSE.equals(content.getOperation())) {
            return;
        }

        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

        Task task = Task.builder()
                .id(content.getId())
                .mainTaskId(content.getId())
                .name(content.getProjectName())
                .startTime(content.getStartTime())
                .endTime(content.getEndTime())
                .personInCharge(content.getPersonInCharge())
                .build();

        //解散项目群
        imService.removeTeam(task.getMainTaskId().toString(),1, authoredUser);

        //解散项目卡包含的所有任务群
        List<PtmBacklog> backlogList = ptmBacklogMapper.selectTaskIdsByProjectCard(content.getId());
        if(CollectionUtils.isNotEmpty(backlogList)){
            backlogList.forEach(bl->{
                imService.removeTeam(bl.getTaskId().toString(), ImTeamType.TaskTeam.getValue(), authoredUser);
            });
        }

    }
}
