package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmProjectGroupDTO;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * PTM 创建项目后，更新IM项目群成员
 */
@Service
@Slf4j
public class PtmProjectUpdateImHandler {
    @Autowired
    private TeamMemberService teamMemberService;

    /**
     * @param event
     */
    public void process(PtmProjectGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        } catch (Exception ex) {
            log.warn("PTM新建项目时更新IM项目群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), event);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * @param event
     */
    private void processEvent(PtmProjectGroupDTO event) {

        if (event == null || event.getAuthoredUser() == null || event.getProject() == null) {
            return;
        }
        log.info("【PtmProjectGroupDTO】：{}", event);

        AuthoredUser authoredUser = event.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

        if (PtmMqOperation.ADD.equals(event.getOperation())
                || PtmMqOperation.CHANGE.equals(event.getOperation())) {

            Task task = Task.builder()
                    .id(event.getProject().getProjectCardId())
                    .mainTaskId(event.getProject().getProjectCardId())
                    .personInCharge(event.getProject().getPersonInCharge())
                    .build();

            //更新项目群
            List<String> relatedUsers = event.getRelatedUsers();
            teamMemberService.updateTeamMemberByFlow(task, authoredUser, relatedUsers);
        }
    }

}
