package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.PtmTaskDeleteGroupDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author wuzq
 * @Date 2023/5/25 13:26
 * @Description: PTM 任务关闭后，解散IM任务群 业务逻辑复制至 TaskEngineActivityHandleService.processActivityStep
 * @Version 1.0
 */
@Slf4j
@Service
public class PtmTaskDeleteGroupHandler{
    @Autowired
    private ImService imService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private ThemeMapService themeMapService;


    public void process(PtmTaskDeleteGroupDTO event) {
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        } catch (Exception ex) {
            log.warn("PTM 解散IM任务群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), event);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * @param content
     */
    private void processEvent(PtmTaskDeleteGroupDTO content) {
        AuthoredUser authoredUser = content.getAuthoredUser();
        if (authoredUser == null
                || !PtmMqOperation.CLOSE.equals(content.getOperation())) {
            return;
        }

        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

        PtmProjectCardRecordDTO ptmProjectCardRecordDTO = ptmService.getProjectCardRecord(content.getProjectCardId());
        TmActivityResponseDTO tmActivityResponseDTO = themeMapService.getActivityAction(ptmProjectCardRecordDTO.getProjectDefCode(), content.getTaskDefCode(), TmPageName.TASK_CARD_NAME.getValue());
        if (!tmActivityResponseDTO.createImGroup()) {
            //不创建IM群，则也不删除群
            return;
        }

        imService.removeTeam(content.getId().toString(), ImTeamType.TaskTeam.getValue(), authoredUser);
    }
}
