package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.TaskOperateSendMsgDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.AimEventDO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Slf4j
@Service
public class TaskOperateSendMsgHandler {

    @Autowired
    private AimService aimService;


    public void process(TaskOperateSendMsgDTO event) {
        try {
            processEvent(event);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(TaskOperateSendMsgDTO backlogOverdueSendMsgNotice) {
        AuthoredUser user = backlogOverdueSendMsgNotice.getAuthoredUser();
        AimEventDO aimEvent = new AimEventDO();
        aimEvent.setGid(UUID.randomUUID().toString());
        aimEvent.setUserId(user.getUserId());
        aimEvent.setUserName(user.getUserName());
        aimEvent.setTenantId(user.getTenantId());
        aimEvent.setSendDate(LocalDateTime.now());
        aimEvent.setType(backlogOverdueSendMsgNotice.getType());
        // 消息体
        Map<String, Object> eventMap = new HashMap<>();
        eventMap.put("backlogId", backlogOverdueSendMsgNotice.getBacklogId());
        eventMap.put("workItemId", backlogOverdueSendMsgNotice.getWorkItemId());
        eventMap.put("taskName", backlogOverdueSendMsgNotice.getTaskName());
        eventMap.put("performerId", backlogOverdueSendMsgNotice.getPerformerId());
        eventMap.put("performerName", backlogOverdueSendMsgNotice.getPerformerName());
        aimEvent.setEvent(eventMap);
//        // 设置过期时间
//        aimEvent.setNeedExpire(true);
//        // 60s
//        aimEvent.setExpireTime("10000");
        log.info("[taskOperateSendMsg] send message, message = {}", JsonUtils.objectToString(aimEvent));
        aimService.sendUrageDealNotice(user, aimEvent);
    }
}
