package com.digiwin.athena.abt.application.service.abt.migration.event.handler;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.CardJob;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.TaskWorkItemMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityPageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmScheduleConfig;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmMqCardMessageService;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageConverter;
import com.digiwin.athena.abt.application.service.abt.migration.summary.RefreshCardMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BpmCommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.CommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.BpmCommonProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.CommonProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.CommonUtils;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskWorkitemMessage;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class TaskWorkitemMessageHandler {
    @Autowired
    private TaskWorkitemMessageMapper taskWorkitemMessageMapper;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    private RefreshCardMessageService refreshCardMessageService;

    @Autowired
    private RefreshCardMessageConverter refreshCardMessageConverter;

    @Autowired
    private CommonBacklogAbstractService backlogHandleService;

    @Autowired
    private BpmCommonBacklogAbstractService bpmBacklogHandleService;

    @Autowired
    private CommonProjectHandleService commonProjectHandleService;

    @Autowired
    private BpmCommonProjectHandleService bpmCommonProjectHandleService;
    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private RedissonClient redissonClient;

    public static final String ADD = "add";
    public static final String UPDATE = "update";

    public static final String PTM_BACKLOG = "ptmBacklog";

    public void process(TaskWorkItemMessageDTO event) {
        // 锁的key
        String lockKey = "redisson:lock:message:" + event.getCardType() + ":" + event.getCardId();
        long timestamp = System.currentTimeMillis();
        // 获取锁
        RLock lock = redissonClient.getLock(lockKey);
        log.info(lockKey + "获取到锁");
        try {
            log.info(lockKey + "尝试加锁，线程：" + Thread.currentThread().getName());
            // 阻塞直到获得锁，自动续期
            lock.lock();
            log.info(lockKey + "已加锁，线程：" + Thread.currentThread().getName());
            // 处理业务逻辑
            processEvent(event);
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        } finally {
            AppAuthContextHolder.clearContext();
            LocaleContextHolder.resetLocaleContext();

            try {
                releaseLockTransAction(lock, lockKey, timestamp);
            } catch (Exception e) {
                log.error("释放锁异常，key：{}，加锁总耗时：{}", lockKey, System.currentTimeMillis() - timestamp);
                log.error("this transaction has exception!", e);
            }
        }
    }

    private void processEvent(TaskWorkItemMessageDTO taskWorkItemMessageModel) {

        log.info("TaskWorkitemMessageSubscriber-event:{}", taskWorkItemMessageModel);

        //token
        AuthoredUser authoredUser = taskWorkItemMessageModel.getAuthoredUser();
        if (authoredUser == null) {
            return;
        }
        //设置token
        AppAuthContext appAuthContext = new AppAuthContext();
        appAuthContext.setAuthoredUser(authoredUser);
        AppAuthContextHolder.setContext(appAuthContext);

        //卡片类型（task-项目，workitem-任务）
        String cardType = taskWorkItemMessageModel.getCardType();
        //卡片id
        Long cardId = taskWorkItemMessageModel.getCardId();
        // 租户id
        String tenantId = StringUtils.isNotEmpty(taskWorkItemMessageModel.getTenantId()) ? taskWorkItemMessageModel.getTenantId() : authoredUser.getTenantId();
        // 操作（add-新增，update-修改），只有任务合并的情况才需要修改摘要和资讯
        String optType = getOptType(taskWorkItemMessageModel.getOptType(), cardId, tenantId, cardType);
        log.info("TaskWorkitemMessageSubscriber-cardId：" + cardId + "；workItemId：" + taskWorkItemMessageModel.getWorkItemId() +"的optType：" + optType);

        //摘要信息
        String summary = "";
        //历史资讯
        String historyMessage = "";
        //搜索数据
        String searchMessage = "";
        //获取卡片摘要信息
        Map summaryMap = null;
        if ("task".equals(cardType)) {
            summaryMap = bpmCommonProjectHandleService.getProjectCardSelfAbstract(authoredUser, cardId, true);
        } else if ("ptmProject".equals(cardType)) {
            // 项目卡不支持活动设计，需直接调用api获取业务数据
            summaryMap = commonProjectHandleService.getProjectCardSelfAbstract(authoredUser, cardId,
                    new CardAbstractDTO().setCardId(cardId).setNeedHistoryInfo(true).setNeedBusinessMessage(true).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_API));
        } else if ("ptmBacklog".equals(cardType)) {
            summaryMap = backlogHandleService.getBacklogCardAbstractById(taskWorkItemMessageModel.getWorkItemId(), authoredUser,
                    new CardAbstractDTO().setCardId(cardId).setNeedHistoryInfo(true).setNeedBusinessMessage(false).setWorkItemIds(taskWorkItemMessageModel.getWorkItemIds()).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_BPM), null);
            /**
             * WorkItemId纬度会漏项目卡纬度的BusinessMessage
             * 需要改为项目卡再执行一次
             * 方法中已经执行了业务数据存储,所以只执行即可
             */
            backlogHandleService.saveTaskSaveBusinessMessage(authoredUser, new CardAbstractDTO().setCardId(cardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_BPM));
        } else {
            summaryMap = bpmBacklogHandleService.getBacklogCardAbstractById(taskWorkItemMessageModel.getWorkItemId(), authoredUser, true);
        }
        log.info("TaskWorkitemMessageSubscriber-summaryMap:{}", summaryMap);
        if (summaryMap != null) {
            summary = (summaryMap.get("summaryLayout") != null) ? (summaryMap.get("summaryLayout").toString()) : "";
            historyMessage = (summaryMap.get("historyMessage") != null) ? (summaryMap.get("historyMessage").toString()) : "";
            searchMessage = (summaryMap.get("searchMessage") != null) ? (summaryMap.get("searchMessage").toString()) : "";
        }
        //任务合并时，叠加主任务的摘要、资讯和搜索数据;否则新增数据
        if ("update".equals(optType) && ("workitem".equals(cardType) || "ptmBacklog".equals(cardType))) {
            updatePtmBacklogOrWorkItemMessage(authoredUser, cardId, taskWorkItemMessageModel.getActivityId(), cardType, summary, historyMessage, searchMessage);
        } else {
            TaskWorkitemMessage taskWorkitemMessage = new TaskWorkitemMessage();
            taskWorkitemMessage.setId(SnowflakeIdWorker.getInstance().newId());
            taskWorkitemMessage.setTenantId(tenantId);
            taskWorkitemMessage.setCardId(taskWorkItemMessageModel.getCardId());
            taskWorkitemMessage.setCreateDate(LocalDateTime.now());
            taskWorkitemMessage.setModifyDate(LocalDateTime.now());
            taskWorkitemMessage.setSummary(summary);
            taskWorkitemMessage.setHistoryMessage(historyMessage);
            taskWorkitemMessage.setSearchMessage(searchMessage);
            taskWorkitemMessage.setCardType(cardType);
            log.info("taskWorkitemMessage:{}", JsonUtils.objectToString(taskWorkitemMessage));
            // 构造摘要
            taskWorkitemMessageMapper.insertOrUpdateMessage(taskWorkitemMessage);
            LogDto logDto = new LogDto("【TaskWorkitemMessageHandler】任务摘要、资讯和搜索数据入库成功，卡片id：" + taskWorkItemMessageModel.getCardId(), authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + taskWorkItemMessageModel.getCardId() + ",活动id:" + taskWorkItemMessageModel.getActivityId());
            log.info(logDto.toString());
            // 为ptm任务卡检查、创建刷新message的定时任务
            if ("ptmBacklog".equals(cardType)) {
                this.createRefreshTaskCardMessageJobIfAbsent(taskWorkItemMessageModel.getWorkItemId(), taskWorkitemMessage.getCardId(), taskWorkitemMessage.getTenantId());
            }
            // 为ptm项目卡检查、创建刷新message的定时任务
            else if ("ptmProject".equals(cardType) && MapUtil.getBool(summaryMap, "scheduleRefreshCardMessage", Boolean.FALSE)) {
                this.createRefreshProjectCardMessageJobIfAbsent(taskWorkitemMessage.getCardId(), MapUtils.getString(summaryMap, "scheduleRefreshCardType"), taskWorkitemMessage.getTenantId());
            }
            if ("ptmProject".equals(cardType)) {
                createNewProjectSchedule(MapUtils.getString(summaryMap, "tmTaskId"), tenantId);
            }
        }

        // 删除redis中的事件
//        delayMessageService.deleteMsgBySeqId(taskWorkitemMessageEventDTO.getSeqId());
    }

    private void updatePtmBacklogOrWorkItemMessage(AuthoredUser authoredUser, Long cardId, Long activityId, String cardType, String summary, String historyMessage, String searchMessage) {
        //通过card找到需要更新的数据
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("card_id", cardId);
        List<TaskWorkitemMessage> taskWorkitemMessageList = taskWorkitemMessageMapper.selectByMap(paramMap);
        if (CollectionUtils.isEmpty(taskWorkitemMessageList)) {
            return;
        }
        TaskWorkitemMessage taskWorkitemMessage = taskWorkitemMessageList.get(0);
        taskWorkitemMessage.setSummary(mergeMessage(taskWorkitemMessage.getSummary(), summary));
        taskWorkitemMessage.setHistoryMessage(mergeMessage(taskWorkitemMessage.getHistoryMessage(), historyMessage));
        taskWorkitemMessage.setSearchMessage(mergeMessage(taskWorkitemMessage.getSearchMessage(), searchMessage));
        taskWorkitemMessage.setModifyDate(LocalDateTime.now());
        boolean isPtmBacklog = PtmMqCardMessageService.PTM_BACKLOG.equals(cardType);
        if (isPtmBacklog) {
            String activityMessageStr = CommonUtils.getActivityMessageStr(taskWorkitemMessage.getActivityMessage(), activityId, CommonUtils.getCardMap(summary, historyMessage, searchMessage));
            taskWorkitemMessage.setActivityMessage(activityMessageStr);
        }
        taskWorkitemMessageMapper.updateById(taskWorkitemMessage);
        LogDto logDto = new LogDto("【TaskWorkitemMessageHandler】任务摘要、资讯和搜索数据更新成功，卡片id：" + cardId, authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + cardId);
        log.info(logDto.toString());
        if (isPtmBacklog) {
            // 根据backlogId查询workItemId信息
            PtmBacklog ptmBacklog = ptmBacklogMapper.selectOne(new LambdaQueryWrapper<PtmBacklog>().eq(PtmBacklog::getBacklogId, cardId));
            if (null == ptmBacklog) {
                return;
            }
            List<PtmBacklog> backlogList = ptmBacklogMapper.selectList(new LambdaQueryWrapper<PtmBacklog>().eq(PtmBacklog::getWorkItemId, ptmBacklog.getWorkItemId()));
            // 说明ptmBacklog有辅助执行者、外部租户的卡
            if (CollectionUtils.size(backlogList) > 1) {
                for (PtmBacklog backlog : backlogList) {
                    // 更新辅助执行者、外部供应商的卡
                    if (null == backlog || cardId.equals(backlog.getBacklogId())) {
                        continue;
                    }
                    LogDto tmpLog = new LogDto("【TaskWorkitemMessageHandler】任务摘要、资讯和搜索数据更新成功，卡片id：" + backlog.getBacklogId(), authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + cardId);
                    log.info(tmpLog.toString());
                    //之前sql执行：UPDATE task_workitem_message SET card_id = 2, card_type = 'ptmProject', tenant_id = '2', summary = 'cesshi2', history_message = 'cesshi2', search_message = 'cesshi2' WHERE card_id = 2
                    //   之前sql执行会将SET card_id = 2, card_type = 'ptmProject', tenant_id = '2'条件拼接上会造成唯一索引冲突Duplicate entry
                    //改过后sql执行：UPDATE task_workitem_message SET summary = 'cesshi2', history_message = 'cesshi2', search_message = 'cesshi2' WHERE card_id = 2
                    taskWorkitemMessageMapper.update(null, new LambdaUpdateWrapper<TaskWorkitemMessage>()
                            .eq(TaskWorkitemMessage::getCardId, backlog.getBacklogId())
                            .set(TaskWorkitemMessage::getSummary, taskWorkitemMessage.getSummary())
                            .set(TaskWorkitemMessage::getHistoryMessage, taskWorkitemMessage.getHistoryMessage())
                            .set(TaskWorkitemMessage::getSearchMessage, taskWorkitemMessage.getSearchMessage())
                    );
                }
            }
        }
    }

    public void createRefreshProjectCardMessageJobIfAbsent(Long projectCardId, String refreshCardType, String tenantId) {
        invokeAbtCreateRefreshCardMessageJob(projectCardId, refreshCardType, CardTypeEnum.PROJECT_CARD.getType(), tenantId);
    }

    public void createRefreshTaskCardMessageJobIfAbsent(Long workItemId, Long taskCardId, String tenantId) {
        TmActivityResponseDTO tmActivity = backlogHandleService.getTaskCardPageDefineByWorkItemId(workItemId);
        if (tmActivity == null) {
            return;
        }
        TmActivityPageDTO pages = tmActivity.getPages();
        if (pages == null) {
            return;
        }
        Boolean scheduleRefreshCardMessage = pages.getScheduleRefreshCardMessage();
        if (BooleanUtil.isTrue(scheduleRefreshCardMessage)) {
            invokeAbtCreateRefreshCardMessageJob(taskCardId, pages.getScheduleRefreshCardType(), CardTypeEnum.TASK_CARD.getType(), tenantId);
        }
        createJob(pages.getScheduleConfig(), tmActivity.getActivityId(), TmPageName.TASK_CARD_NAME.getValue(), tenantId);
    }

    public void createNewProjectSchedule(String tmTaskId, String tenantId) {
        if (StringUtils.isNotBlank(tmTaskId)) {
            try {
                TmTaskDefineResponseDTO projectDefine = themeMapService.getTask(tmTaskId);
                if (projectDefine != null) {
                    Map pages = projectDefine.getPages();
                    if (pages != null) {
                        Object o = pages.get(TmPageName.PROJECT_CARD_NAME.getValue());
                        if (o == null) {
                            return;
                        }
                        TmActivityPageDTO tmActivityPageDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(o), TmActivityPageDTO.class);
                        createJob(tmActivityPageDTO.getScheduleConfig(), tmTaskId, TmPageName.PROJECT_CARD_NAME.getValue(), tenantId);
                    }
                }
            } catch (Exception e) {
                log.error("场景新项目卡定时任务失败,taskId:{},错误信息:{}", tmTaskId, e.getMessage(), e);
            }
        }
    }

    private void createJob(TmScheduleConfig scheduleConfig, String code, String pageCode, String tenantId) {
        if (scheduleConfig != null) {
            CardJob job = new CardJob();
            job.setEnable(scheduleConfig.getEnable());
            job.setRefreshCardType(scheduleConfig.getRefreshCardType());
            job.setCode(code);
            job.setTenantId(tenantId);
            job.setPagCode(pageCode);
            refreshCardMessageService.createOrUpdateCardJob(job);
        }
    }

    private void invokeAbtCreateRefreshCardMessageJob(Long cardId, String refreshCardType, int cardType, String tenantId) {
        RefreshCardMessageDTO refreshCardMessageDTO = new RefreshCardMessageDTO();
        refreshCardMessageDTO.setId(cardId);
        refreshCardMessageDTO.setCardType(cardType);
        refreshCardMessageDTO.setTenantId(tenantId);
        refreshCardMessageDTO.setRefreshCardType(refreshCardType);
        try {
            RefreshCardMessageDTO refreshCardMessageDO = refreshCardMessageConverter.to(refreshCardMessageDTO);
            refreshCardMessageService.createRefreshCardMessageJobIfAbsent(refreshCardMessageDO);
        } catch (Exception ex) {
            log.warn("create refresh card message job{}.{}.{} failed, error: {}", cardId, tenantId, cardType, ex.getMessage(), ex);
        }
    }

    public String mergeMessage(String message, String subMessage) {
        /**
         * 简单合并：直接比较subMessage和message是否相同，相同则返回message；不相同，subMessage追加到message
         */
        if (StringUtils.isBlank(message)) {
            return subMessage;
        }

        if (StringUtils.equals(message, subMessage) || StringUtils.isBlank(subMessage)) {
            return message;
        }

        return message + "<br>" + subMessage;
    }

    /**
     * 获取操作类型
     * @param backlogId
     * @param tenantId
     * @param cardType
     * @return
     */
    private String getOptType(String optType, Long backlogId, String tenantId, String cardType) {
        if (StringUtils.isNotBlank(optType)) {
            return optType;
        }
        // 查询项目卡/任务卡是否已记录信息
        List<TaskWorkitemMessage> taskWorkitemMessages = findMessage(backlogId, tenantId, cardType);
        // 判断新增数据还是修改数据
        return CollectionUtils.isEmpty(taskWorkitemMessages) ? ADD : UPDATE;
    }


    /**
     * 查询任务卡是否已存在message数据
     *
     * @Author：SYQ
     * @Date：2022/11/11 13:30
     */
    private List<TaskWorkitemMessage> findMessage(Long backlogId, String tenantId, String cardType) {
        QueryWrapper<TaskWorkitemMessage> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("card_id", backlogId);
        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("card_type", cardType);
        return taskWorkitemMessageMapper.selectList(queryWrapper);
    }


    /**
     * 释放锁
     * @param lock
     * @param lockKey
     */
    private void releaseLockTransAction(RLock lock, String lockKey, long timestamp) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter() {
                @Override
                public void afterCompletion(int status) {
                    log.info("异步事务中开始释放锁，key：{}，加锁总耗时：{}", lockKey, System.currentTimeMillis() - timestamp);
                    long startReleaseLockTimestamp = System.currentTimeMillis();
                    //无论执行结果如何，解锁当前操作
                    releaseLock(lock, lockKey);
                    log.info("异步事务中释放锁结束，key：{}，加锁总耗时：{}, 释放锁总耗时：{}", lockKey, System.currentTimeMillis() - timestamp, System.currentTimeMillis() - startReleaseLockTimestamp);
                }
            });
        } else {
            log.info("开始释放锁，key：{}，加锁总耗时：{}", lockKey, System.currentTimeMillis() - timestamp);
            long startReleaseLockTimestamp = System.currentTimeMillis();
            //无论执行结果如何，解锁当前操作
            releaseLock(lock, lockKey);
            log.info("释放锁结束，key：{}，加锁总耗时：{}, 释放锁总耗时：{}", lockKey, System.currentTimeMillis() - timestamp, System.currentTimeMillis() - startReleaseLockTimestamp);
        }
    }


    private void releaseLock(RLock lock, String lockKey) {
        log.info(lockKey + "isHeldByCurrentThread = " + lock.isHeldByCurrentThread() + "，线程：" + Thread.currentThread().getName());
        // 释放锁
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
            log.info(lockKey + "释放锁，线程：" + Thread.currentThread().getName());
        }
    }
}
