package com.digiwin.athena.abt.application.service.abt.migration.groupteam;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmMqGroupTeamService;
import com.digiwin.athena.abt.core.meta.constants.EventModelConstants;
import com.digiwin.athena.abt.core.meta.constants.EventMqConstants;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * 事件-群聊模版
 */
@Slf4j
@Service
public class EventGroupTeamMessageModel extends EventBaseService implements EventInterface {
    @Autowired
    private PtmMqGroupTeamService ptmMqGroupTeamService;

    /**
     * 支持消息类型
     *
     * @return
     */
    @Override
    public String modelType() {
        return EventModelConstants.GROUP_TEAM_MODEL;
    }

    /**
     * 分发消息
     *
     * @param
     * @param data
     */
    @Override
    public void distributeMessages(String data) {
        rabbitTemplate.convertAndSend(EventMqConstants.EVENT_MQ_EXCHANGE_NAME, EventMqConstants.EVENT_MQ_GROUP_TEAM_ROUTING, data);
    }

    /**
     * 消费消息
     *
     * @param data
     */
    @Override
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_MQ_GROUP_TEAM_QUEUE, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_MQ_GROUP_TEAM_ROUTING
    ), concurrency = "#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('" + EventMqConstants.EVENT_MQ_GROUP_TEAM_QUEUE + "')}")
    @RabbitRetry(beforeHandler = "ptmMqBeforeHandler", successHander = "ptmMqSuccessHandler", failureHandler = "ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag, @Header(value = "retry-count", required = false) Integer retryCount) {
        super.receiveOrder(data, EventMqConstants.EVENT_MQ_GROUP_TEAM_QUEUE, channel, tag, retryCount);
    }

    /**
     * 重写：处理mq消息
     */
    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        LogDto logDto = new LogDto("【EventGroupTeamMessageModel】处理群聊消息，消息类型：" + mqMessageDTO.getType().getValue(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + mqMessageDTO.getType().getValue());
        log.info(logDto.toString());
        if (EventMqTypeEnum.backlog.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processTaskCreateGroupMessage(data, user);
        } else if (EventMqTypeEnum.task.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processTaskDeleteGroupMessage(data, user);
        } else if (EventMqTypeEnum.projectCard.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processProjectCardGroupMessage(data, user);
        } else if (EventMqTypeEnum.project.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processProjectGroupMessage(data, user);
        } else if (EventMqTypeEnum.flowProjectCard.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processFlowProjectCardGroupMessage(data, mqMessageDTO.getFlowUser());
        } else if (EventMqTypeEnum.flowProject.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processFlowProjectGroupMessage(data, mqMessageDTO.getFlowUser());
        } else if (EventMqTypeEnum.flowBacklog.equals(mqMessageDTO.getType())) {
            ptmMqGroupTeamService.processFlowBacklogGroupMessage(data, mqMessageDTO.getFlowUser());
        }
    }
}
