package com.digiwin.athena.abt.application.service.abt.migration.groupteam;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.im.ImBpmActivityTeamDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.im.ImTeamDTO;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivity;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author：SYQ
 * @date：2021/6/10
 */
@Service
public class TeamMemberService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private EocService eocService;
    @Autowired
    private ImService imService;

    private static final Logger logger = LoggerFactory.getLogger(TeamMemberService.class);

    private boolean disableIM() {
        return StringUtils.isBlank(envProperties.getImUri());
    }

    /**
     * 创建项目卡时创建项目群
     * PS:转派人员在转派时添加入群内
     *
     * @Author：SYQ
     * @Date：2021/6/10 15:21
     */
    public void createTaskTeam(Task task, AuthoredUser user, List<String> relatedUserList, String businessKey) {
        // 禁用IM
        if (disableIM()) {
            return;
        }
        if (task == null) {
            return;
        }
        //群主
        String owner = eocService.getEocEmpInfo(task.getPersonInCharge(), user);
        //群名
        String taskName = messageUtils.getMessageByCurrentLanguage(task.getName());
        if(StringUtils.isEmpty(taskName)) {
            taskName = messageUtils.getMessageByCurrentLanguage(task.getProjectName());
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("MM/dd");
        String startTime = df.format(task.getStartTime());
        String endTime = df.format(task.getEndTime());
        String teamName = startTime + "-" + endTime + taskName;
        //主项目id
        String bizId = task.getMainTaskId().toString();
        //类型
        int type = 1;
        //是主群
        int ifMaster = 1;
        //不可见
        int visiable = 0;
        /*获取群成员 start*/
        List<String> userList = new ArrayList<>();
        //新创建的项目没有任务
        //根据业务数据取得对应人员（暂时没有接口）
        if (relatedUserList != null && relatedUserList.size() > 0) {
            userList.addAll(relatedUserList);
        }
//        TmUserDTO tmUserDTO = new TmUserDTO();
//        tmUserDTO.setIdentities(tmRelatedUserDTO.getIdentities());
//        List<TmUserResponseDto> tmUserList = eocFacadeService.query(tmUserDTO,"",
//                bpmProcess.getData(),bpmProcess.getBusinessUnit());
        //获取代理人
        String proxyUser = getPorxyUser(user, task.getPersonInCharge());
        if (StringUtils.isNotEmpty(proxyUser)) {
            userList.add(proxyUser);
        }
        //判断是不是内部员工
        List<String> memberList = userService.getEmployee(userList, user);
        /*获取群成员 end*/

        //创建群
        imService.createTeam(user, owner, teamName, bizId, type, ifMaster, visiable, memberList, "", null, null, businessKey);
        LogDto logDto = new LogDto("创建项目卡时创建项目群成功，项目id：" + task.getMainTaskId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + task.getMainTaskId());
        logger.info(logDto.toString());
        //创建外部人员私聊
//        createTeamByAccount(user,relatedUserList,owner,bizId,"",type,teamName);
    }


    /**
     * 项目卡新增子流程时向项目群内添加成员
     *
     * @Author：SYQ
     * @Date：2021/6/10 15:28
     */
    public void updateTeamMemberByFlow(Task task, AuthoredUser user, List<String> relatedUserList) {
        // 禁用IM
        if (disableIM()) {
            return;
        }

        //群唯一标识
        String bizId = task.getMainTaskId().toString();
        //项目群
        int type = 1;
        //群成员
        List<String> userList = new ArrayList<>();
        //获取代理人
        String proxyUser = getPorxyUser(user, task.getPersonInCharge());
        if (StringUtils.isNotEmpty(proxyUser)) {
            userList.add(proxyUser);
        }
        //根据业务数据取得对应人员（暂时没有接口）
        if (relatedUserList != null && relatedUserList.size() > 0) {
            userList.addAll(relatedUserList);
        }
        //判断是不是内部员工
        List<String> memberList = userService.getEmployee(userList, user);
        //添加群成员
        LogDto logDto = new LogDto("项目卡新增子流程时向项目群内添加成员成功，添加的群成员：" + JsonUtils.objectToString(userList), user.getTenantId() + LogConstant.TRACE_SEPARATOR + task.getMainTaskId());
        logger.info(logDto.toString());
        this.addTeamMembers(user, bizId, type, memberList);
       /* //创建外部人员私聊
        String owner = getEocEmpInfo(task.getPersonInCharge(),user);
        String taskName = messageUtils.getMessageByCurrentLanguage(task.getName());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("MM/dd");
        String startTime = df.format(task.getStartTime());
        String endTime = df.format(task.getEndTime());
        String teamName = startTime + "-" + endTime + taskName;
        createTeamByAccount(user,relatedUserList,owner,bizId, "",type,teamName);*/
    }

    /**
     * 创建任务群（区分外部任务和内部任务）
     *
     * @Author：SYQ
     * @Date：2021/7/5 17:48
     */
    public void createBpmActivityTeam(BpmActivity bpmActivity, Boolean isBpmActivityStepEmpty, List<BpmActivityWorkitem> workitemList, AuthoredUser user, List<String> relatedUserList,
                                      int isExternal, String plan, String tenantSid, String tenantName, String businessKey) {
        // 禁用IM
        if (disableIM()) {
            return;
        }

        if (bpmActivity == null || isBpmActivityStepEmpty || CollectionUtils.isEmpty(workitemList)) {
            return;
        }

        //判断存不存在PCC任务群，若存在只需修改cardIds字段，否则创建新群
        if (StringUtils.isNotEmpty(businessKey)) {
            Map teamMap = imService.getTeamInfo(user, businessKey, ImTeamType.TaskTeam.getValue(), "pcc");
            //存在，将当前任务卡的bpmActivityId存入cardIds字段
            if (teamMap != null) {
                String cardIds = "";
                if (teamMap.get("cardIds") != null) {
                    cardIds = bpmActivity.getId().toString() + "," + teamMap.get("cardIds");
                } else {
                    cardIds = bpmActivity.getId().toString();
                }
                imService.updateTeamInfo(user, teamMap.get("tId").toString(), cardIds);
                return;
            }
        }

        //获取任务的主项目
        Task mainTask = taskMapper.getPartialMainProjectByBpmActivitySqlId(bpmActivity.getId());
        if (mainTask == null) {
            return;
        }

        List<ImBpmActivityTeamDTO.Performer> performerList = new ArrayList<>();
        workitemList.forEach(wi -> {
            ImBpmActivityTeamDTO.Performer performer = ImBpmActivityTeamDTO.Performer.builder()
                    .performerId(wi.getPerformerId())
                    .performerName(wi.getPerformerName())
                    .build();
            performerList.add(performer);
        });

        ImBpmActivityTeamDTO bpmActivityTeamDTO = ImBpmActivityTeamDTO.builder()
                .bpmActivityId(bpmActivity.getId())
                .tmActivityName(bpmActivity.getTmActivityName())
                .bpmActivityPlanEndTime(bpmActivity.getPlanEndTime())
                .performerList(performerList)
                .relatedUserList(relatedUserList)
                .isExternal(isExternal)
                .plan(plan)
                .tenantSid(tenantSid)
                .tenantName(tenantName)
                .imBusinessKey(businessKey)
                .mainTaskId(mainTask.getId())
                .mainTaskPersonInCharge(mainTask.getPersonInCharge())
                .mainTaskPersonInChargeName(mainTask.getPersonInChargeName())
                .build();

        createBpmActivityTeam(bpmActivityTeamDTO, user);
        LogDto logDto = new LogDto("创建bpm任务群成功，bpmActivityId：" + bpmActivity.getId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + bpmActivity.getId());
        logger.info(logDto.toString());
    }

    /**
     * 创建任务群（区分外部任务和内部任务）
     *
     * @param bpmActivityTeamDTO
     * @param user
     */
    public void createBpmActivityTeam(ImBpmActivityTeamDTO bpmActivityTeamDTO, AuthoredUser user) {

        // 禁用IM
        if (disableIM()) {
            return;
        }

        if (bpmActivityTeamDTO == null || CollectionUtils.isEmpty(bpmActivityTeamDTO.getPerformerList())) {
            return;
        }

        //判断存不存在PCC任务群，若存在只需修改cardIds字段，否则创建新群
        if (StringUtils.isNotEmpty(bpmActivityTeamDTO.getImBusinessKey())) {
            Map teamMap = imService.getTeamInfo(user, bpmActivityTeamDTO.getImBusinessKey(), ImTeamType.TaskTeam.getValue(), "pcc");
            //存在，将当前任务卡的bpmActivityId存入cardIds字段
            if (teamMap != null) {
                String cardIds = "";
                if (teamMap.get("cardIds") != null) {
                    cardIds = bpmActivityTeamDTO.getBpmActivityId().toString() + "," + teamMap.get("cardIds");
                } else {
                    cardIds = bpmActivityTeamDTO.getBpmActivityId().toString();
                }
                imService.updateTeamInfo(user, teamMap.get("tId").toString(), cardIds);
                return;
            }
        }

        ImTeamDTO teamDTO = new ImTeamDTO();

        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        //群名
        String activityName = MessageUtils.getMessageByCurrentLanguage(bpmActivityTeamDTO.getTmActivityName());
        teamDTO.setTeamName(String.format(messageUtils.getMessageByLangName("msg.record.backlog.performer.notice.msg", langName),
                TimeUtils.format(bpmActivityTeamDTO.getBpmActivityPlanEndTime(), "MM/dd"),
                activityName));

        //任务群的Id
        teamDTO.setBizId(bpmActivityTeamDTO.getBpmActivityId().toString());
        //群类型
        teamDTO.setTeamType(ImTeamType.TaskTeam);
        //是主群
        teamDTO.setIfMaster(1);
        //不可见
        teamDTO.setVisiable(0);
        //主项目id
        teamDTO.setPId(bpmActivityTeamDTO.getMainTaskId().toString());
        //获取群成员
        List<String> userList = new ArrayList<>();

        //region 获取代理人
        List<String> proxyUserList = new ArrayList<>();
        for (ImBpmActivityTeamDTO.Performer workitem : bpmActivityTeamDTO.getPerformerList()) {
            String proxyUser = getPorxyUser(user, workitem.getPerformerId());
            if (StringUtils.isNotEmpty(proxyUser)) {
                proxyUserList.add(proxyUser);
            }
        }
        userList.addAll(proxyUserList);
        //endregion

        //根据业务数据获取对应人员
        if (bpmActivityTeamDTO.getRelatedUserList() != null && bpmActivityTeamDTO.getRelatedUserList().size() > 0) {
            userList.addAll(bpmActivityTeamDTO.getRelatedUserList());
        }
        //任务相关人员(EOC账户)
        teamDTO.setExternalEocMembers(new ArrayList<>());
        //任务相关人员(用户账户)
        teamDTO.setExternalAccounts(new ArrayList<>());
        //外部任务
        if (bpmActivityTeamDTO.getIsExternal() == 1) {
            //群主为所属项目的当责者
            teamDTO.setOwner(eocService.getEocEmpInfo(bpmActivityTeamDTO.getMainTaskPersonInCharge(), user));
            //场景一，发送邮件
            if ("email".equals(bpmActivityTeamDTO.getPlan())) {
                //外部供应商
                Map<String, String> map = new HashMap<>();
                map.put("uniqueId", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId());
                map.put("userName", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerName());
                map.put("tenantName", "企业用户");
                teamDTO.getExternalAccounts().add(map);
            } else if ("card".equals(bpmActivityTeamDTO.getPlan())) {//场景二，发送任务卡
                String eocUserId = eocService.getEocByTenantAndUser(user, bpmActivityTeamDTO.getTenantSid(), bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId());
                if (StringUtils.isNotEmpty(eocUserId)) {
                    Map<String, Object> map = new HashMap<>();
                    map.put("tenantId", Long.valueOf(bpmActivityTeamDTO.getTenantSid()));
                    map.put("eocId", eocUserId);
                    map.put("tenantName", bpmActivityTeamDTO.getTenantName());
                    teamDTO.getExternalEocMembers().add(map);
                } else {
                    Map<String, String> map = new HashMap<>();
                    map.put("uniqueId", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId());
                    map.put("userName", bpmActivityTeamDTO.getPerformerList().get(0).getPerformerName());
                    map.put("tenantName", "企业用户");
                    teamDTO.getExternalAccounts().add(map);
                }
            }
        } else {
            //群主,如果多人取第一个人
            teamDTO.setOwner(eocService.getEocEmpInfo(bpmActivityTeamDTO.getPerformerList().get(0).getPerformerId(), user));
            //项目当责者
            userList.add(bpmActivityTeamDTO.getMainTaskPersonInCharge());
            //所属项目群添加成员
            List<String> taskUserList = new ArrayList<>();
            //任务执行人
            for (ImBpmActivityTeamDTO.Performer workitem : bpmActivityTeamDTO.getPerformerList()) {
                taskUserList.add(workitem.getPerformerId());
            }
            //任务代理人
            if (!CollectionUtils.isEmpty(proxyUserList)) {
                taskUserList.addAll(proxyUserList);
            }
            List<String> taskMemberList = userService.getEmployee(taskUserList, user);
            //添加项目群成员
            this.addTeamMembers(user, teamDTO.getPId(), ImTeamType.ProjectTeam.getValue(), taskMemberList);
        }
        //内部成员
        teamDTO.setMemberList(userService.getEmployee(userList, user));
        //业务主键

        //创建任务群
        imService.createTeam(user, teamDTO.getOwner(), teamDTO.getTeamName(), teamDTO.getBizId(), teamDTO.getTeamType().getValue(),
                teamDTO.getIfMaster(), teamDTO.getVisiable(), teamDTO.getMemberList(), teamDTO.getPId(),
                teamDTO.getExternalAccounts(), teamDTO.getExternalEocMembers(), "");
        LogDto logDto = new LogDto("创建bpm任务群成功，bpmActivityId：" + bpmActivityTeamDTO.getBpmActivityId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + bpmActivityTeamDTO.getBpmActivityId());
        logger.info(logDto.toString());
        //创建外部人员私聊
        createTeamByAccount(user, bpmActivityTeamDTO.getRelatedUserList(), teamDTO.getOwner(), teamDTO.getBizId(), teamDTO.getPId(), teamDTO.getTeamType().getValue(), teamDTO.getTeamName());
        LogDto logDtoOuter = new LogDto("创建外部人员私聊成功，bpmActivityId：" + bpmActivityTeamDTO.getBpmActivityId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + bpmActivityTeamDTO.getBpmActivityId());
        logger.info(logDtoOuter.toString());
    }

    /**
     * 项目转派时添加项目群成员及任务群成员
     *
     * @Author：SYQ
     * @Date：2021/6/10 17:40
     */
    public void transferTaskMemeber(AuthoredUser user, Task task, List<String> userIdList) {
        // 禁用IM
        if (disableIM()) {
            return;
        }

        if (task != null && CollUtil.isNotEmpty(userIdList)) {
            //内部员工
            List<String> memberList = userService.getEmployee(userIdList, user);
            //项目群添加成员
            this.addTeamMembers(user, task.getId().toString(), 1, memberList);
            LogDto logDto = new LogDto("添加项目群成员成功，任务id：" + task.getId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + task.getId());
            logger.info(logDto.toString());
            //获取该项目下的所有任务
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("task_id", task.getId());
            List<Backlog> backlogList = backlogMapper.selectByMap(paramMap);
            if (backlogList == null || backlogList.isEmpty()) {
                return;
            }
            //该项目下的所有任务群添加转派人
            for (Backlog backlog : backlogList) {
                //任务群添加成员
                this.addTeamMembers(user, backlog.getId().toString(), 2, memberList);
                LogDto logDtBacklog = new LogDto("添加任务群成员成功，任务id：" + backlog.getId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + backlog.getId());
                logger.info(logDtBacklog.toString());
            }
        }
    }

    /**
     * 任务转派时添加任务群成员及项目群成员
     *
     * @Author：SYQ
     * @Date：2021/6/10 18:02
     */
//    public void addBpmActivityTeamMember(AuthoredUser user, Long bpmActivitySqlId, String userId) {
//        List<String> userIdList = new ArrayList<>();
//        userIdList.add(userId);
//        addBpmActivityTeamMember(user, bpmActivitySqlId, userIdList);
//    }

    /**
     * 向任务群中添加群成员
     *
     * @param user
     * @param bpmActivitySqlId
     * @param userIdList       人员列表，例如emp001、emp002等
     */
    public void addBpmActivityTeamMember(AuthoredUser user, Long bpmActivitySqlId, List<String> userIdList) {
        // 禁用IM
        if (disableIM()) {
            return;
        }

        if (bpmActivitySqlId == null || Objects.equals(bpmActivitySqlId, 0) || CollectionUtils.isEmpty(userIdList)) {
            return;
        }

        //内部员工
        List<String> memberList = userService.getEmployee(userIdList, user);

        //任务群添加成员
        this.addTeamMembers(user, bpmActivitySqlId.toString(), ImTeamType.TaskTeam.getValue(), memberList);
        LogDto logDtBacklog = new LogDto("添加任务群成员成功，bpmActivitySqlId：" + bpmActivitySqlId, user.getTenantId() + LogConstant.TRACE_SEPARATOR + bpmActivitySqlId);
        logger.info(logDtBacklog.toString());
        //任务所属成员
        Task mainTask = taskMapper.getPartialMainProjectByBpmActivitySqlId(bpmActivitySqlId);
        if (mainTask != null) {
            //项目群添加成员
            this.addTeamMembers(user, mainTask.getId().toString(), ImTeamType.ProjectTeam.getValue(), memberList);
            LogDto logDto = new LogDto("添加项目群成员成功，任务id：" + mainTask.getId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + bpmActivitySqlId);
            logger.info(logDto.toString());
        }

    }

    /**
     * 获取代理人
     *
     * @Author：SYQ
     * @Date：2021/6/10 16:30
     */
    private String getPorxyUser(AuthoredUser user, String userId) {
        String proxyUser = "";
        UserDTO userDTO = userService.getTargetUser(userId, user.getToken());
        if (userDTO != null && StringUtils.isNotEmpty(userDTO.getId()) && !userId.equals(userDTO.getId())) {
            proxyUser = userDTO.getId();
        }
        return proxyUser;
    }

    /**
     * 有外部关联人时，创建一个任务执行人和外部关联的私聊群
     *
     * @Author：SYQ
     * @Date：2021/7/15 18:00
     */
    private void createTeamByAccount(AuthoredUser user, List<String> relatedUserList, String owner, String bizId, String pId,
                                     int type, String teamName) {
        if (relatedUserList == null || relatedUserList.size() == 0) {
            return;
        }
        for (String userId : relatedUserList) {
            //eocId
            String eocId = eocService.getEocEmpInfo(userId, user);
            //是内部人员忽略
            if (StringUtils.isNotEmpty(eocId)) {
                continue;
            }
            //获取用户信息
            UserDTO userDTO = userService.query(userId);
            if (userDTO == null) {
                return;
            }
            Map<String, String> map = new HashMap<>();
            map.put("uniqueId", userId);
            map.put("userName", userDTO.getName());
            map.put("tenantName", "企业用户");

            List<Map> externalAccounts = new ArrayList<>();
            externalAccounts.add(map);

            //创建私聊
            imService.createTeam(user, owner, teamName, bizId, type, 0, 0, null,
                    pId, externalAccounts, null, "");
            LogDto logDto = new LogDto("创建任务执行人和外部关联的私聊群成功，userId：" + userId, user.getTenantId() + LogConstant.TRACE_SEPARATOR + userId);
            logger.info(logDto.toString());
        }
    }

    /**
     * 添加群成员
     * @param user
     * @param bizId
     * @param type
     * @param memberList
     */
    private void addTeamMembers(AuthoredUser user, String bizId, int type, List<String> memberList) {
        List<String> list = memberList.stream().filter(StrUtil::isNotBlank).collect(Collectors.toList());
        if (CollUtil.isEmpty(list)) {
            return;
        }
        imService.addTeamMembers(user, bizId, type, list);
    }
}
