package com.digiwin.athena.abt.application.service.abt.migration.helpler;

import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.utils.ExcelHellper;
import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.application.utils.MyCollectionUtils;
import com.digiwin.athena.abt.core.ie.excel.convert.StringConversionUtils;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.jugg.agile.framework.core.config.JaProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.digiwin.athena.abt.core.meta.constants.ContainerConstant.REQUIRED_STR_FOR_TRUE;

/**
 * 采用追加写的方式execl工具类v2
 */
@Slf4j
@Service
public class ExcelHelperV2 implements InitializingBean {
    private static final String JAVA_IO_TMPDIR = TempFile.JAVA_IO_TMPDIR;
    static final String POIFILES = "poifiles";
    private final String EXCEL_SUFFIX = ".xlsx";
    public static final String HEADER_KEY = "key";
    private static final String HEADER_NAME = "name";


    public static final String HEADER_CHILDREN = "headers";
    public static final String ERROR_FIELD_SUFFIX = "_error_msg";

    /**
     * 数据类型
     */
    private static final String DATA_TYPE = "dataType";

    /**
     * 枚举
     */
    private static final String OPTIONS = "options";

    /**
     * 枚举的描述
     */
    private static final String TITLE = "title";

    /**
     * 枚举code
     */
    private static final String VALUE = "value";

    /**
     * 读取sheet页中的数据
     *
     * @param sheet
     * @return
     */
    public List<Map> readData(Sheet sheet) {
        //将存在合并单元格的列记录入put进hashmap并返回
        Map<String, Integer[]> map = ExcelUtil.getMergedRegionMap(sheet);
        //去除空行后的sheet页
        Sheet sheetExcepNullRow = ExcelUtil.getAccuracyContextNum(sheet, map);

        //第一二行为headers
        List<String> headerKeys = new LinkedList<>();
        Row headRow2 = sheetExcepNullRow.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow2.getCell(cellStartIdx)) {
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            headerKeys.add(key);
            cellStartIdx++;
        }
        List<Map> data = new LinkedList<>();
        int rowStartIdx = 2;
        while (null != sheetExcepNullRow.getRow(rowStartIdx)) {
            Map<String, Object> rowData = new HashMap<>();
            for (int i = 0; i < headerKeys.size(); i++) {
                CellType cellType = sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getCellTypeEnum();
                switch (cellType) {
                    case STRING:
                        rowData.put(headerKeys.get(i), sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getStringCellValue());
                        break;
                    case BOOLEAN:
                        rowData.put(headerKeys.get(i), sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getBooleanCellValue());
                        break;
                    case NUMERIC:
                        rowData.put(headerKeys.get(i), sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getNumericCellValue());
                        break;
                    default:
                        rowData.put(headerKeys.get(i), "");
                        break;
                }

                if (null != sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getCellComment()) {
                    String cellComment = sheetExcepNullRow.getRow(rowStartIdx).getCell(i).getCellComment().getString().getString();
                    rowData.put(headerKeys.get(i) + ERROR_FIELD_SUFFIX, cellComment);
                }
            }
            data.add(rowData);
            rowStartIdx++;
        }
        return data;
    }

    public List<Map> readData(Sheet sheet, List<String> headerKeys) {
        List<Map> data = new LinkedList<>();
        int rowStartIdx = 2;
        while (null != sheet.getRow(rowStartIdx)) {
            Map<String, Object> rowData = new HashMap<>();
            for (int i = 0; i < headerKeys.size(); i++) {
                CellType cellType = sheet.getRow(rowStartIdx).getCell(i).getCellTypeEnum();
                switch (cellType) {
                    case STRING:
                        rowData.put(headerKeys.get(i), sheet.getRow(rowStartIdx).getCell(i).getStringCellValue());
                        break;
                    case BOOLEAN:
                        rowData.put(headerKeys.get(i), sheet.getRow(rowStartIdx).getCell(i).getBooleanCellValue());
                        break;
                    case NUMERIC:
                        rowData.put(headerKeys.get(i), sheet.getRow(rowStartIdx).getCell(i).getNumericCellValue());
                        break;
                    default:
                        rowData.put(headerKeys.get(i), "");
                        break;
                }

                if (null != sheet.getRow(rowStartIdx).getCell(i).getCellComment()) {
                    String cellComment = sheet.getRow(rowStartIdx).getCell(i).getCellComment().getString().getString();
                    rowData.put(headerKeys.get(i) + ERROR_FIELD_SUFFIX, cellComment);
                }
            }
            data.add(rowData);
            rowStartIdx++;
        }
        return data;
    }

    public List<Map> readData(Workbook wb, List<String> headerKeys, List<String> mainKeys) {
        //读取单身数据
        int sheetNum = wb.getNumberOfSheets();
        Map<String, Map<String, List<Map>>> bodyDataMap = new HashMap<>();
        if (hasBody(sheetNum)) {
            //忽略单头
            for (int i = 1; i < sheetNum; i++) {
                Sheet bodySheet = wb.getSheetAt(i);
                String sheetName = bodySheet.getSheetName();
                List<Map> readData = readData(bodySheet);
                Map<String, List<Map>> groupedMap = MyCollectionUtils
                        .groupingBy(readData, MyCollectionUtils.formMapGroupFunctions(mainKeys));
                bodyDataMap.put(sheetName, groupedMap);
            }
        }
        //读取单头数据
        Sheet sheet = wb.getSheetAt(0);
        List<Map> data = new LinkedList<>();
        int rowStartIdx = 2;
        while (null != sheet.getRow(rowStartIdx)) {
            Map<String, Object> rowData = new HashMap<>();
            String joinedKey = "";
            //遍历单头数据
            for (int i = 0; i < headerKeys.size(); i++) {
                String keyCode = headerKeys.get(i);
                CellType cellType = sheet.getRow(rowStartIdx).getCell(i).getCellTypeEnum();
                switch (cellType) {
                    case STRING:
                        rowData.put(keyCode, sheet.getRow(rowStartIdx).getCell(i).getStringCellValue());
                        break;
                    case BOOLEAN:
                        rowData.put(keyCode, sheet.getRow(rowStartIdx).getCell(i).getBooleanCellValue());
                        break;
                    case NUMERIC:
                        rowData.put(keyCode, sheet.getRow(rowStartIdx).getCell(i).getNumericCellValue());
                        break;
                    default:
                        rowData.put(keyCode, "");
                        break;
                }
                if (mainKeys.contains(keyCode)) {
                    joinedKey = joinedKey + (StringUtils.isEmpty(joinedKey) ? "" : MyCollectionUtils.DEFAULT_DELIMITER) + sheet.getRow(rowStartIdx).getCell(i).getStringCellValue();
                }
                if (null != sheet.getRow(rowStartIdx).getCell(i).getCellComment()) {
                    String cellComment = sheet.getRow(rowStartIdx).getCell(i).getCellComment().getString().getString();
                    rowData.put(headerKeys.get(i) + ERROR_FIELD_SUFFIX, cellComment);
                }
            }
            if (hasBody(sheetNum)) {
                //依次读取单身数据,并附加到单头
                for (int i = 1; i < sheetNum; i++) {
                    Sheet bodySheet = wb.getSheetAt(i);
                    String sheetName = bodySheet.getSheetName();
                    List<Map> bodyList = bodyDataMap.get(sheetName).get(joinedKey) == null ? Collections.EMPTY_LIST : bodyDataMap.get(sheetName).get(joinedKey);
                    removeBodyBusinessKey(bodyList, mainKeys);
                    rowData.put(ExcelUtil.getSheetNameInParens(sheetName), bodyList);
                }
            }
            data.add(rowData);
            rowStartIdx++;
        }
        return data;
    }

    public List<Map> readRootData(Workbook wb, String mainKeyName, Map<String, CellTypeContainer> cellTypeContainerMap) {
        CellTypeContainer rootTypeContainerMap = new CellTypeContainer();
        rootTypeContainerMap.setKeyName(mainKeyName);
        rootTypeContainerMap.setProtoType(MetaDataType.OBJECT);
        rootTypeContainerMap.setChildren(new ArrayList<>());
        rootTypeContainerMap.getChildren().addAll(cellTypeContainerMap.values());

        //所有页签的数据
        Map<String, List<Map>> sheetDataMap = readExcelData(wb, mainKeyName);

        //加载数据
        List<Map> data = readEntityData(rootTypeContainerMap, sheetDataMap, null);
        return data;
    }

    /**
     * 读取全部excel,每个key一个sheet
     *
     * @param wb
     * @return
     */
    public Map<String, List<String>> readExcelHeaders(Workbook wb, String mainKey) {
        Map<String, List<String>> data = new HashMap<>();
        try {
            //读取单身数据
            int sheetNum = wb.getNumberOfSheets();
            //忽略单头
            for (int i = 0; i < sheetNum; i++) {
                Sheet bodySheet = wb.getSheetAt(i);
                List<String> headers = doreadExcelHeaders(bodySheet);
                String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
                // 针对旧的excel可能还存在sheet1这种名称做特殊处理，sheet name变为metadata的main key
                if (ExcelUtil.MAIN_SHEET_NAME.equals(sheetName)) {
                    data.put(mainKey, headers);
                } else {
                    data.put(sheetName, headers);
                }
            }
        } catch (Exception e) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0116.getErrCode(), MessageUtil.getMessageByLocale("upload.template.error", LocaleContextHolder.getLocale().toString()));
        }
        return data;
    }

    public List<String> doreadExcelHeaders(Sheet sheet) {
        //第一二行为headers
        List<String> headerKeys = new LinkedList<>();
        Row headRow2 = sheet.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow2.getCell(cellStartIdx)) {
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            headerKeys.add(key);
            cellStartIdx++;
        }
        return headerKeys;
    }

    /**
     * 读取全部excel,每个key一个sheet
     *
     * @param wb
     * @param mainKey
     * @return
     */
    public Map<String, List<Map>> readExcelData(Workbook wb, String mainKey) {
        Map<String, List<Map>> data = new HashMap<>();
        //读取单身数据
        int sheetNum = wb.getNumberOfSheets();
        //忽略单头
        for (int i = 0; i < sheetNum; i++) {
            Sheet bodySheet = wb.getSheetAt(i);
            List<Map> readData = readData(bodySheet);
            String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
            // 针对旧的excel可能还存在sheet1这种名称做特殊处理，sheet name变为metadata的main key
            if (ExcelUtil.MAIN_SHEET_NAME.equals(sheetName)) {
                data.put(mainKey, readData);
            } else {
                data.put(sheetName, readData);
            }
        }
        return data;
    }

    /**
     * 获取sheet页对应的栏位元数据定义
     */
    public Map<String, List<ApiDataFieldLocaleMetadataDTO>> getSheetMetadataMap(Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetMetadataMap, String sheetName, int sheetNo, ApiDataFieldLocaleMetadataDTO mainMetadata, UploadParamDTO uploadParam) {
        if (null == mainMetadata || CollectionUtils.isEmpty(mainMetadata.getField())) {
            log.error("getActionLocaleResponseDTO is null!");
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0092.getErrCode(), MessageUtil.getMessage("basedata.metaDataStructError"));
        }
        Map<String, Set<String>> sheetRequiredFiledMap = uploadParam.getActionInfo().getSheetRequiredFiled();
//        Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetMetadataMap = new HashMap<>();
        Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetBkMap = new HashMap<>();
        Map<String, Set<String>> sheetBkRequiredFiled = new HashMap<>();
        //忽略单头
        if (sheetNo == 0) {
            // 使用jackson深拷贝，不影响后续对元数据GetActionLocaleResponseDTO的使用
            List<ApiDataFieldLocaleMetadataDTO> fieldLocaleMetadataDTOS = JsonUtils.jsonToListObject(JsonUtils.objectToString(mainMetadata.getField()), ApiDataFieldLocaleMetadataDTO.class);
            // 获取单身和对应的BK
            getBkMetadataMap(sheetBkMap, fieldLocaleMetadataDTOS, sheetBkRequiredFiled, uploadParam.getRequiredFields());
            sheetMetadataMap.put(sheetName, fieldLocaleMetadataDTOS);
            sheetRequiredFiledMap.put(sheetName, uploadParam.getRequiredFields());//设置首页必填项
        } else {
            // 处理单身、子单身sheet页
            Iterator<Map.Entry<String, List<ApiDataFieldLocaleMetadataDTO>>> iterator = sheetMetadataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                List<ApiDataFieldLocaleMetadataDTO> metadataDTOS = iterator.next().getValue();
                Optional<ApiDataFieldLocaleMetadataDTO> optional = metadataDTOS.stream().filter(metadataDTO -> metadataDTO.getData_name().equals(sheetName)).findFirst();
                if (optional.isPresent()) {
                    ApiDataFieldLocaleMetadataDTO metadataDTO = optional.get();
                    Set<String> addRequiredFields = new HashSet<>();
                    addRequiredFields = reBuildRequiredFields(metadataDTO.getField(), sheetBkRequiredFiled, sheetName);
                    sheetRequiredFiledMap.put(sheetName, addRequiredFields);//设置首页必填项
                    // 获取单身和对应的BK，以及下一层sheet页必填项
                    getBkMetadataMap(sheetBkMap, metadataDTO.getField(), sheetBkRequiredFiled, addRequiredFields);
                    sheetMetadataMap.put(sheetName, metadataDTO.getField());
                    if (!CollectionUtils.isEmpty(sheetBkMap) && !CollectionUtils.isEmpty(sheetBkMap.get(sheetName))) {
                        sheetMetadataMap.get(sheetName).addAll(sheetBkMap.get(sheetName));
                    }
                    break;
                }
            }

        }
        return sheetMetadataMap;
    }

    private Set<String> reBuildRequiredFields(List<ApiDataFieldLocaleMetadataDTO> field, Map<String, Set<String>> sheetBkRequiredFiled, String sheetName) {
        Set<String> requiredFields = new HashSet<>();
        if (!CollectionUtils.isEmpty(sheetBkRequiredFiled.get(sheetName))) {
            requiredFields = sheetBkRequiredFiled.get(sheetName);
        }
        if (CollectionUtils.isEmpty(field)) {
            return requiredFields;
        }
        Set<String> resultFields = new HashSet<>(requiredFields);
        for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO : field) {
            if (REQUIRED_STR_FOR_TRUE.equals(apiDataFieldLocaleMetadataDTO.getRequired())) {
                resultFields.add(apiDataFieldLocaleMetadataDTO.getData_name());
            }

        }
        return resultFields;
    }

    /**
     * 获取单身和对应的BK，以及下一层sheet页必填项
     *
     * @param sheetBkMap
     * @param fieldLocaleMetadataDTOS
     */
    public void getBkMetadataMap(Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetBkMap, List<ApiDataFieldLocaleMetadataDTO> fieldLocaleMetadataDTOS, Map<String, Set<String>> sheetBkRequiredFiled, Set<String> requiredFields) {
        List<ApiDataFieldLocaleMetadataDTO> bks = fieldLocaleMetadataDTOS.stream().filter(metadataDTO -> metadataDTO.getIs_businesskey()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bks)) {
            return;
        }
        List<ApiDataFieldLocaleMetadataDTO> arrayFields = fieldLocaleMetadataDTOS.stream().filter(metadataDTO -> metadataDTO.getIs_array()).collect(Collectors.toList());
        arrayFields.forEach(arrayField -> {
            sheetBkMap.put(arrayField.getData_name(), bks);
            sheetBkRequiredFiled.put(arrayField.getData_name(), requiredFields);
        });
    }

    /**
     * 读取全部excel,每个key一个sheet
     *
     * @param wb
     * @return
     */
    public Map<String, List<Map>> readExcelDataForImport(Workbook wb, String mainKey, Map<String, List<ApiDataFieldLocaleMetadataDTO>> sheetMetadataMap) {
        Map<String, List<Map>> data = new HashMap<>();
        //读取单身数据
        int sheetNum = wb.getNumberOfSheets();
        //忽略单头
        for (int i = 0; i < sheetNum; i++) {
            Sheet bodySheet = wb.getSheetAt(i);
            String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
            List<ApiDataFieldLocaleMetadataDTO> metadataDTOS = sheetMetadataMap.get(sheetName);
            List<Map> readData = new ArrayList<>();
            readData = ExcelUtil.readDataForImport(bodySheet, metadataDTOS);
            // 针对旧的excel可能还存在sheet1这种名称做特殊处理，sheet name变为metadata的main key
            if (ExcelUtil.MAIN_SHEET_NAME.equals(sheetName)) {
                data.put(mainKey, readData);
            } else {
                data.put(sheetName, readData);
            }
        }
        return data;
    }

    private List<Map> readEntityData(CellTypeContainer cellTypeContainer, Map<String, List<Map>> sheetDataMap, Map parentBKMap) {
        List<Map> data = new ArrayList<>();

        List<Map> sheetData = sheetDataMap.get(cellTypeContainer.getKeyName());
        List<String> businessKeys = getKeys(cellTypeContainer.getChildren());
        if (MapUtils.isEmpty(parentBKMap)) {
            parentBKMap = new HashMap();
        }

        if (CollectionUtils.isEmpty(sheetData)) {
            return new ArrayList<>();
        }

        for (Map rowData : sheetData) {
            if (MapUtils.isEmpty(parentBKMap)) {
                data.add(rowData);
            } else if (compareBusinessKey(rowData, parentBKMap)) {
                data.add(rowData);
            } else {
                continue;
            }

            //当前的主键
            Map businessKeyMap = new HashMap();
            if (MapUtils.isEmpty(parentBKMap)) {
                businessKeyMap.putAll(parentBKMap);
            }
            for (String bk : businessKeys) {
                businessKeyMap.put(bk, rowData.get(bk));
            }

            //处理单身
            if (!CollectionUtils.isEmpty(cellTypeContainer.getChildren())) {
                for (CellTypeContainer child : cellTypeContainer.getChildren()) {
                    if (child.getProtoType() == MetaDataType.OBJECT) {
                        List<Map> childList = readEntityData(child, sheetDataMap, businessKeyMap);
                        rowData.put(child.getKeyName(), childList);
                    }
                }
            }
        }

        return data;
    }

    /**
     * 判断行数据是否匹配BK值
     *
     * @param rowData
     * @param businessKeyMap
     * @return
     */
    public Boolean compareBusinessKey(Map rowData, Map businessKeyMap) {
        Object[] businessKeys = businessKeyMap.keySet().toArray();
        for (Object businessKey : businessKeys) {
            if (!rowData.containsKey(businessKey)) {
                return false;
            } else if (!Objects.equals(rowData.get(businessKey), businessKeyMap.get(businessKey))) {
                return false;
            }
        }
        return true;
    }

    private List<String> getKeys(List<CellTypeContainer> cellTypes) {
        List<String> keys = new ArrayList<>();
        if (CollectionUtils.isEmpty(cellTypes)) {
            return keys;
        }
        for (CellTypeContainer cellType : cellTypes) {
            if (cellType.getBusinessKey()) {
                keys.add(cellType.getKeyName());
            }
        }
        return keys;
    }

    private void removeBodyBusinessKey(List<Map> bodyList, List<String> mainKeys) {
        if (!CollectionUtils.isEmpty(bodyList)) {
            bodyList.forEach(map -> {
                Set<String> set = map.keySet();
                Iterator<String> it = set.iterator();
                while (it.hasNext()) {
                    String key = it.next();
                    if (mainKeys.contains(key)) {
                        it.remove();
                    }
                }
            });
        }
    }

    private boolean hasBody(int sheetNum) {
        return sheetNum > 1;
    }

    /**
     * @return
     * @Author zhuangli
     * @Description 多单身方式读取headers
     * @Date 14:06 2023/1/30
     * @Param
     **/
    public List<Map> readHeaders(Workbook wb, Map<String, CellTypeContainer> cellTypeContainerMap, List<String> headerKeys, List<String> mainKeys) {
        //获取单头sheet
        Sheet sheet = wb.getSheetAt(0);
        int sheetTotalNum = wb.getNumberOfSheets();
        List<Map> headers = new LinkedList<>();
        //第一二行为headers
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow1.getCell(cellStartIdx)) {
            String val = headRow1.getCell(cellStartIdx).getStringCellValue();
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            Map<String, Object> cell = new HashMap<>();
            cell.put(HEADER_KEY, key);
            cell.put(HEADER_NAME, val);
            // 返回枚举值
            setDict(key, cell, cellTypeContainerMap);
            headerKeys.add(key);
            headers.add(cell);
            cellStartIdx++;
        }
        //顺序读取单身
        if (hasBody(sheetTotalNum)) {
            //忽略单头
            for (int i = 1; i < sheetTotalNum; i++) {
                Map<String, Object> cell = readBodyHeaders(i, wb, cellTypeContainerMap, mainKeys);
                if (!CollectionUtils.isEmpty(cell)) {
                    headers.add(cell);
                }
            }
        }
        return headers;
    }

    private Map<String, Object> readBodyHeaders(int sheetNum, Workbook wb, Map<String, CellTypeContainer> cellTypeContainerMap, List<String> mainKeys) {
        if (sheetNum >= wb.getNumberOfSheets()) {
            return null;
        }

        Sheet bodySheet = wb.getSheetAt(sheetNum);
        String sheetName = ExcelUtil.getSheetNameInParens(bodySheet.getSheetName());
        CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(sheetName);
        if (null == cellTypeContainer) {
            return null;
        }

        Map<String, CellTypeContainer> cellTypeChildMap = new HashMap<>();
        if (cellTypeContainer.getArray() && !CollectionUtils.isEmpty(cellTypeContainer.getChildren())) {
            cellTypeChildMap = cellTypeContainer.getChildren().stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity()));
        }

        List<Map> bodyHeaders = new LinkedList<>();
        //第一二行为headers
        Row bodyHeadRow1 = bodySheet.getRow(0);
        Row bodyHeadRow2 = bodySheet.getRow(1);
        int bodyCellStartIdx = 0;
        while (null != bodyHeadRow1.getCell(bodyCellStartIdx)) {
            String val = bodyHeadRow1.getCell(bodyCellStartIdx).getStringCellValue();
            String key = bodyHeadRow2.getCell(bodyCellStartIdx).getStringCellValue();
            List<String> needRemoveBkList = getNeedRemoveBkList(mainKeys, cellTypeChildMap);
            // 不添加上层bk
            if (!needRemoveBkList.contains(key)) {
                Map<String, Object> cell = new HashMap<>();
                cell.put(HEADER_KEY, key);
                cell.put(HEADER_NAME, val);
                bodyHeaders.add(cell);
            }
            bodyCellStartIdx++;
        }

        if (!CollectionUtils.isEmpty(cellTypeChildMap)) {
            // 返回枚举值
            for (Map cell : bodyHeaders) {
                String key = (String) cell.get(HEADER_KEY);
                setDict(key, cell, cellTypeChildMap);
            }

            List<String> parentBks = ExcelUtil.getBusinessKeyList(cellTypeContainer.getChildren());
            Map<String, Object> cell = readBodyHeaders(++sheetNum, wb, cellTypeChildMap, parentBks);
            if (!CollectionUtils.isEmpty(cell)) {
                bodyHeaders.add(cell);
            }
        }

        Map<String, Object> cell = new HashMap<>(4);
        cell.put(HEADER_KEY, sheetName);
        //国际化
        cell.put(HEADER_NAME, cellTypeContainer.getKeyDescription());
        cell.put(HEADER_CHILDREN, bodyHeaders);
        //headerKeys.add(sheetName);

        return cell;
    }

    /**
     * 获取需要剔除的BK字段
     *
     * @param mainKeys
     * @param cellTypeChildMap
     * @return
     */
    private List<String> getNeedRemoveBkList(List<String> mainKeys, Map<String, CellTypeContainer> cellTypeChildMap) {
        // 单身的key
        Set<String> keyNameSet = cellTypeChildMap.keySet();
        // 需要剔除的BK字段
        List<String> needRemoveBkList = new ArrayList<>();
        mainKeys.forEach(data -> {
                    // 虽然是上层BK，但是单身也定义了该BK字段，则保留
                    if (!keyNameSet.contains(data)) {
                        needRemoveBkList.add(data);
                    }
                }
        );
        return needRemoveBkList;
    }

    /**
     * 返回枚举值
     *
     * @param key
     * @param cell
     * @param cellTypeContainerMap
     */
    private void setDict(String key, Map<String, Object> cell, Map<String, CellTypeContainer> cellTypeContainerMap) {
        CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(key);
        if (null == cellTypeContainer) {
            return;
        }

        if (null != cellTypeContainer.getCellType()) {
            cell.put(DATA_TYPE, cellTypeContainer.getProtoType().name().toLowerCase());
        }

        if (!CollectionUtils.isEmpty(cellTypeContainer.getDictionaries())) {
            List<Map<String, String>> options = new ArrayList<>();
            cell.put(OPTIONS, options);
            cellTypeContainer.getDictionaries().forEach(dictionary -> {
                Map<String, String> option = new HashMap<>();
                option.put(VALUE, dictionary.getCode());
                option.put(TITLE, dictionary.getValue());
                options.add(option);
            });
        }
    }

    public List<Map> readHeaders(Sheet sheet, List<String> headerKeys) {
        List<Map> headers = new LinkedList<>();
        //第一二行为headers
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        int cellStartIdx = 0;
        while (null != headRow1.getCell(cellStartIdx)) {
            String val = headRow1.getCell(cellStartIdx).getStringCellValue();
            String key = headRow2.getCell(cellStartIdx).getStringCellValue();
            Map<String, String> cell = new HashMap<>(3);
            cell.put(HEADER_KEY, key);
            cell.put(HEADER_NAME, val);
            headerKeys.add(key);
            headers.add(cell);
            cellStartIdx++;
        }
        return headers;
    }

    public void createDataExcel(String SHEET_NAME, String locale, int rowIndex, List<String> keyList, Map<String, CellTypeContainer> cellTypeContainerMap,
                                Map<String, String> headers, List<Map<String, Object>> dataTable, Workbook wb,
                                List<CellTypeContainer> businessKeyContainer, int parentIdSize, CellTypeContainer cellTypeContainerMain,
                                List<CellTypeContainer> cellTypesList, Set<String> arrayField) {
        Sheet sheet = wb.getSheet(SHEET_NAME);
        if (null == sheet) {
            sheet = wb.createSheet(SHEET_NAME);
        }
//        List<CellTypeContainer> arrayKeyContainer = getArrayKeyContainer(new ArrayList<>(cellTypeContainerMap.values()));
//        Set<String> arrayField = new HashSet<>();
//        if (!CollectionUtils.isEmpty(arrayKeyContainer)) {
//            arrayField = arrayKeyContainer.stream().map(CellTypeContainer::getKeyName).collect(Collectors.toSet());
//        }
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum <= 0) {
            /*创建行Rows及单元格Cells*/
            //第一二行为标题
            Row headRow1 = sheet.createRow(0);
            Row headRow2 = sheet.createRow(1);

            //遍历顺序按照keyList顺序
            int colIndex = 0;
            for (int i = 0; i < keyList.size(); i++) {
                if (arrayField.contains(keyList.get(i))) {
                    continue;
                }
                //创建单元格
                Cell cell1 = headRow1.createCell(colIndex);
                Cell cell2 = headRow2.createCell(colIndex);
                //设置值
                cell1.setCellValue(headers.get(keyList.get(i)));
                cell2.setCellValue(keyList.get(i));
                colIndex++;
            }
        }
            /*List<String> headerArray = new ArrayList<>(headers.size());
            for (int i = 0; i < headers.size(); i++) {
                headerArray.add((String) headers.get(i).get(HEADER_KEY));
            }*/
        //当前行索引,跳过标题计算
        DataFormat fmt = wb.createDataFormat();
        //设置单元格格式
        int colIndex = 0;
        for (int i = 0; i < keyList.size(); i++) {
            if (!cellTypeContainerMap.containsKey(keyList.get(i))) {
                log.error("字段不存在： {}", keyList.get(i));
            }
            //设置列属性
            MetaDataType metaDataType = cellTypeContainerMap.get(keyList.get(i)).getProtoType();
            CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(keyList.get(i));
            if (cellTypeContainer.getKeyName().contains("_error_msg")) {
                continue;
            }
            CellStyle cellStyle = wb.createCellStyle();
            cellTypeContainer.setCellStyle(cellStyle);
            switch (metaDataType) {
                case STRING:
                    if (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0) {
                        ExcelUtil.excelRuleStringLength(locale, sheet, 0, cellTypeContainer.getPrecision()[0], 2,
                                65536, colIndex, colIndex);
                    }
                    cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(colIndex, cellStyle);
                    break;
                case NUMBER:
                    //cellTypeContainer.setPrecision(new int[]{5, 3});
                    ExcelUtil.excelRuleIsNumber(locale, sheet, 2, 65536, colIndex, colIndex);
                    break;
                case DATE:
                    cellStyle.setDataFormat(fmt.getFormat(cellTypeContainer.getDateFormat()));
                    sheet.setDefaultColumnStyle(colIndex, cellStyle);
                    ExcelUtil.excelRuleDateFormat(locale, sheet, "1720-01-01", "",
                            cellTypeContainer.getDateFormat(), 2, 65536, colIndex, colIndex);
                /*cellStyle.setDataFormat(fmt.getFormat("@"));
                sheet.setDefaultColumnStyle(i, cellStyle);*/
                    break;
                case OBJECT:
                    if (cellTypeContainer.getArray() && null != businessKeyContainer) {
                        String childSheetName = ExcelHelperV2.getSheetName(cellTypeContainer.getKeyName(), cellTypeContainer.getKeyDescription(), false);
                        //获取子表字段
                        List<CellTypeContainer> cellTypes = cellTypeContainer.getChildren();
                        List<CellTypeContainer> childBusinessKeyContainer = getBusinessKeyContainer(cellTypes);
                        // 兼容DF中也配置了BK的场景:先从DF中剔除调BK，再将BK统一添加到最前面
                        addBkContainer(cellTypes, businessKeyContainer);
                        //记录父id字段长度,特殊处理
                        int parentIdSizeForChild = businessKeyContainer.size();
                        List<String> childKeyList = new ArrayList<>();
                        Map<String, String> childHeaders = new HashMap<>();
                        for (CellTypeContainer item : cellTypes) {
                            if (item.getKeyName().contains("_error_msg")) {
                                continue;
                            }
                            // 解决无法导出单身问题 bug:63701
                            childKeyList.add(item.getKeyName());
                            childHeaders.put(item.getKeyName(), item.getKeyDescription());
                        }
                        Map<String, CellTypeContainer> chiledCellTypeContainerMap = cellTypes.stream().collect(Collectors.toMap(CellTypeContainer::getKeyName, Function.identity()));
                        List<Map<String, Object>> bodyDataList = new ArrayList<>();
                        for (Map map : dataTable) {
                            String keyName = cellTypeContainer.getKeyName();
                            Object content = map.get(keyName);
                            try {
                                if (null == content || (content instanceof List && CollectionUtils.isEmpty((List) content))) {
                                    continue;
                                }
                                if (!(content instanceof List)) {
                                    continue;
                                }
                                List<Map<String, Object>> bodyData = (List<Map<String, Object>>) content;
                                for (Map bodyDataMap : bodyData) {
                                    //填充parentId字段
                                    for (int j = 0; j < parentIdSizeForChild; j++) {
                                        //判断
                                        CellTypeContainer bkCellTypeContainer = businessKeyContainer.get(j);
                                        Object bkValue = map.get(bkCellTypeContainer.getKeyName());
                                        bodyDataMap.put(bkCellTypeContainer.getKeyName(), bkValue);
                                    }
                                }
                                bodyDataList.addAll(bodyData);
                            } catch (Exception e) {
                                log.error("parse body error:{}", content);
                            }
                        }

                        this.createDataExcel(childSheetName, locale, rowIndex, childKeyList, chiledCellTypeContainerMap, childHeaders, bodyDataList, wb, childBusinessKeyContainer, parentIdSizeForChild, cellTypeContainerMain, cellTypes, arrayField);
                        //i标识数据从第几列取
//                        createChildSheet(wb, rowIndex, businessKeyContainer, cellTypeContainer, locale, dataTable);
                        continue;
                    }
                    if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                        ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, colIndex, colIndex);
                    }
                    break;
                case BOOLEAN:
                    ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, colIndex, colIndex);
                    break;
                case ENUM:
                    if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                        ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, colIndex, colIndex);
                    }
                    break;
                default:
                    break;
            }
            colIndex++;
        }

        //创建Rows,填数据
        if (CollectionUtils.isEmpty(dataTable)) {
            return;
        }
        if (null == cellTypeContainerMain) {
            for (int i = 0; i < dataTable.size(); i++) {
                Row row = null;
                if (lastRowNum <= 0) {
                    row = sheet.createRow(rowIndex++);
                } else {
                    row = sheet.createRow(lastRowNum + 1 + i);
                }

                Map<String, Object> rowMap = dataTable.get(i);
                int cellIndex = 0;
                for (int j = 0; j < keyList.size(); j++) {
                    if (arrayField.contains(keyList.get(j))) {
                        continue;
                    }
                    CellTypeContainer cellTypeContainer = cellTypeContainerMap.get(keyList.get(j));
                    if (cellTypeContainer.getKeyName().contains("_error_msg")) {
                        continue;
                    }
                    Object value = rowMap.get(keyList.get(j));
                    fillData(row, cellIndex, cellTypeContainer, value, rowMap);
                    cellIndex++;
                }
            }
        } else {
            if (lastRowNum > 0) {
                rowIndex = lastRowNum + 1;
            }
            fillSheetData(sheet, rowIndex, parentIdSize, cellTypeContainerMain, cellTypesList, dataTable);
        }

    }

    public List<CellTypeContainer> getArrayKeyContainer(ArrayList<CellTypeContainer> cellTypes) {
        List<CellTypeContainer> cellTypeContainers = new LinkedList<>();
        for (CellTypeContainer cellType : cellTypes) {
            if (cellType.getArray()) {
                cellTypeContainers.add(cellType);
            }
        }
        return cellTypeContainers;
    }

    private void fillSheetData(Sheet sheet, int rowIndex, int parentIdSize, CellTypeContainer cellTypeContainerMain, List<CellTypeContainer> cellTypes, List<Map<String, Object>> errorTable) {
        //统计行数
        for (Map map : errorTable) {
            String keyName = cellTypeContainerMain.getKeyName();
            Object content = map.get(keyName);
            List<Map> bodyData;
            try {
                if (null == content || (content instanceof List && CollectionUtils.isEmpty((List) content))) {
                    continue;
                }
                if (!(content instanceof List)) {
                    continue;
                }
                bodyData = JsonUtils.jsonToListObject(JsonUtils.objectToString(content), Map.class);
            } catch (Exception e) {
                log.error("parse body error:{}", content);
                continue;
            }
            for (Map bodyDataMap : bodyData) {
                Row row = sheet.createRow(rowIndex);
                //填充parentId字段
                for (int i = 0; i < parentIdSize; i++) {
                    //判断
                    CellTypeContainer cellTypeContainer = cellTypes.get(i);
                    Object value = map.get(cellTypeContainer.getKeyName());
                    fillData(row, i, cellTypeContainer, value, map);
                }
                //填充单身数据
                int fillColIndex = parentIdSize;
                for (int i = parentIdSize; i < cellTypes.size(); i++) {
                    CellTypeContainer cellTypeContainer = cellTypes.get(i);
                    if (cellTypeContainer.getKeyName().contains("_error_msg")) {
                        continue;
                    }
                    Object value = bodyDataMap.get(cellTypeContainer.getKeyName());
                    Object valueComment = bodyDataMap.get(cellTypeContainer.getKeyName() + "_error_msg");
                    fillData(row, fillColIndex, cellTypeContainer, value, map);
                    if (!isEmpty(valueComment)) {
                        ExcelHellper.addComment(row.getCell(fillColIndex), String.valueOf(valueComment), EXCEL_SUFFIX);
                    }
                    fillColIndex++;
                }
                rowIndex++;
            }

        }
    }

    private boolean isEmpty(Object value) {
        return null == value || StringUtils.isEmpty(StringUtils.isEmpty(value));
    }

    private void fillData(Row row, int column, CellTypeContainer cellTypeContainer, Object value, Map rowMap) {
        Cell cell = row.createCell(column);
        cell.setCellStyle(cellTypeContainer.getCellStyle());
        switch (cellTypeContainer.getCellType()) {
            case STRING:
                if (cellTypeContainer.getProtoType() == MetaDataType.ENUM) {
                    if (StringUtils.isEmpty(value)) {
                        cell.setCellValue("");
                    } else {
                        cell.setCellValue(value + "." + cellTypeContainer.getDictMap().get(String.valueOf(value)));
                    }
                } else {
                    if (value instanceof Double) {
                        cell.setCellValue((Double) value);
                    } else if (value instanceof Integer) {
                        cell.setCellValue((Integer) value);
                    } else if (value instanceof BigDecimal) {
                        cell.setCellValue(((BigDecimal) value).doubleValue());
                    } else if (value instanceof String) {
                        cell.setCellValue((String) value);
                    } else if (value instanceof Boolean) {
                        cell.setCellValue((Boolean) value);
                    } else {
                        cell.setCellValue((value == null) ? "" : value.toString());
                    }
                }
                break;
            case BOOLEAN:
                if (cellTypeContainer.getProtoType() == MetaDataType.ENUM) {
                    if (StringUtils.isEmpty(value)) {
                        cell.setCellValue("");
                    } else {
                        cell.setCellValue(value + "." + cellTypeContainer.getDictMap().get(String.valueOf(value)));
                    }
                } else {
                    if (value instanceof Boolean) {
                        cell.setCellValue(String.valueOf(value).toUpperCase());
                    } else if (null == value) {
                        cell.setCellValue("");
                    }
                }
                break;
            case NUMERIC:
                if (cellTypeContainer.getProtoType() == MetaDataType.ENUM) {
                    if (StringUtils.isEmpty(value)) {
                        cell.setCellValue("");
                    } else {
                        cell.setCellValue(value + "." + cellTypeContainer.getDictMap().get(String.valueOf(value)));
                    }
                } else {
                    if (value instanceof Double) {
                        cell.setCellValue((Double) value);
                    } else if (value instanceof Integer) {
                        cell.setCellValue((Integer) value);
                    } else if (value instanceof BigDecimal) {
                        cell.setCellValue(((BigDecimal) value).doubleValue());
                    } else if (null == value) {
                        cell.setCellValue("");
                    } else if (value instanceof String) {
//                        boolean isBigDecimal = StringConversionUtils.isNumericBigDecimal((String) value);
//                        if (isBigDecimal) {
                            cell.setCellValue((String) value);
//                        }
                    }
                }
                break;
            case BLANK:
                cell.setCellValue(String.valueOf(value));
                break;
            default:
                cell.setCellValue(String.valueOf(value));
                break;
        }
        if (null != rowMap.get(cellTypeContainer.getKeyName() + ERROR_FIELD_SUFFIX)) {
            ExcelHellper.addComment(cell, String.valueOf(rowMap.get(cellTypeContainer.getKeyName() + ERROR_FIELD_SUFFIX)), EXCEL_SUFFIX);
        }
    }

    public List<CellTypeContainer> getBusinessKeyContainer(List<CellTypeContainer> cellTypes) {
        List<CellTypeContainer> cellTypeContainers = new LinkedList<>();
        for (CellTypeContainer cellType : cellTypes) {
            if (cellType.getBusinessKey()) {
                cellTypeContainers.add(cellType);
            }
        }
        return cellTypeContainers;
    }


    private void createChildSheet(Workbook wb, int rowIndex, List<CellTypeContainer> businessKeyContainer, CellTypeContainer cellTypeContainerMain, String locale, List<Map<String, Object>> errorTable) {
        String sheetName = ExcelHelperV2.getSheetName(cellTypeContainerMain.getKeyName(), cellTypeContainerMain.getKeyDescription(), false);
        Sheet sheet = wb.createSheet(sheetName);
        //获取子表字段
        List<CellTypeContainer> cellTypes = cellTypeContainerMain.getChildren();
        // 兼容DF中也配置了BK的场景:先从DF中剔除调BK，再将BK统一添加到最前面
        addBkContainer(cellTypes, businessKeyContainer);
        //记录父id字段长度,特殊处理
        int parentIdSize = businessKeyContainer.size();
        createSheetHeader(wb, sheet, cellTypes, locale, null);
        fillSheetData(sheet, rowIndex, parentIdSize, cellTypeContainerMain, cellTypes, errorTable);
    }

    /**
     * 兼容DF中也配置了BK的场景:先从DF中剔除调BK，再将BK统一添加到最前面
     *
     * @param cellTypes
     * @param businessKeyContainer
     */
    public void addBkContainer(List<CellTypeContainer> cellTypes, List<CellTypeContainer> businessKeyContainer) {
        Iterator<CellTypeContainer> cellTypeIterator = cellTypes.iterator();
        while (cellTypeIterator.hasNext()) {
            CellTypeContainer cellType = cellTypeIterator.next();
            Iterator<CellTypeContainer> bkTypeIterator = businessKeyContainer.iterator();
            while (bkTypeIterator.hasNext()) {
                CellTypeContainer bkType = bkTypeIterator.next();
                if (cellType.getKeyName().equals(bkType.getKeyName())) {
                    cellTypeIterator.remove();
                }
            }
        }
        //父id字段添加到数组头
        cellTypes.addAll(0, businessKeyContainer);
    }

    private void createSheetHeader(Workbook wb, Sheet sheet, List<CellTypeContainer> cellTypes, String locale, Set<String> requiredFields) {
        DataFormat fmt = wb.createDataFormat();
        int index = 0;
        //设置列属性
        for (int i = 0; i < cellTypes.size(); i++) {
            MetaDataType metaDataType = cellTypes.get(i).getProtoType();
            CellTypeContainer cellTypeContainer = cellTypes.get(i);
            if (cellTypeContainer.getKeyName().contains("_error_msg")) {
                continue;
            }
            CellStyle cellStyle = wb.createCellStyle();
            cellTypeContainer.setCellStyle(cellStyle);
            switch (metaDataType) {
                case STRING:
                    if (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0) {
                        ExcelUtil.excelRuleStringLength(locale, sheet, 0, cellTypeContainer.getPrecision()[0], 2,
                                65536, index, index);
                    }
                    cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(index, cellStyle);
                    break;
                case NUMBER:
                    //cellTypeContainer.setPrecision(new int[]{5, 3});
                    ExcelUtil.excelRuleIsNumber(locale, sheet, 2, 65536, index, index);
                    break;
                case DATE:
                    cellStyle.setDataFormat(fmt.getFormat(cellTypeContainer.getDateFormat()));
                    sheet.setDefaultColumnStyle(index, cellStyle);
                    ExcelUtil.excelRuleDateFormat(locale, sheet, "1720-01-01", "",
                            cellTypeContainer.getDateFormat(), 2, 65536, index, index);
                    /*cellStyle.setDataFormat(fmt.getFormat("@"));
                    sheet.setDefaultColumnStyle(i, cellStyle);*/
                    break;
                case OBJECT:
                    //log.error("不应该出现的类型for actionId:{}", actionId);
                    //判断是否是数组类型,且单头存在businessKey
                    if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                        ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index);
                    }
                    break;
                case BOOLEAN:
                    ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index);
                    break;
                case ENUM:
                    if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                        ExcelUtil.excelRuleSelect(locale, sheet, cellTypeContainer.getListEnum(), 2, 65536, index, index);
                    }
                    break;
                default:
                    break;
            }
            index++;
        }
        /*创建行Rows及单元格Cells*/
        //第一二行为标题
        Row headRow1 = sheet.createRow(0);
        Row headRow2 = sheet.createRow(1);
        //重置index
        index = 0;
        for (int i = 0; i < cellTypes.size(); i++) {
            if (cellTypes.get(i).getKeyName().contains("_error_msg")) {
                continue;
            }
            //跳过单身字段
            if (!cellTypes.get(i).getArray()) {
                //创建单元格
                Cell cell1 = headRow1.createCell(index);
                Cell cell2 = headRow2.createCell(index);
                //设置值
                if ((!CollectionUtils.isEmpty(requiredFields)) && requiredFields.contains(cellTypes.get(i).getKeyName())) {
                    cell1.setCellValue(ExcelUtil.addRequiredMark((XSSFWorkbook) wb, cellTypes.get(i).getKeyDescription(), wb.getFontAt(cell1.getCellStyle().getFontIndex())));
                    cell2.setCellValue(cellTypes.get(i).getKeyName());
                } else {
                    cell1.setCellValue(cellTypes.get(i).getKeyDescription());
                    cell2.setCellValue(cellTypes.get(i).getKeyName());
                }
                index++;
            }
        }
    }


    //不要修改原来的逻辑
    public static String getSheetName(String nameEN, String nameZH, Boolean header) {
        int sizeZH = nameZH.length();
        int sizeEN = nameEN.length();
        //如果英文名称字符大于31个直接返回
        if (sizeEN > 31) {
            if (header) {
                return "sheet1";
            }
            return replaceIllegalSheetName(nameEN);
        }

        if (sizeEN == 31 || sizeEN == 30) {
            return replaceIllegalSheetName(nameEN);
        }

        StringBuilder sb = new StringBuilder();
        //case1：当没有zh的时候
        if (nameZH == null || nameZH.isEmpty()) {
            //(DataEntry_tbds_bom_maintenance)
            sb.append("(").append(nameEN).append(")");
            return replaceIllegalSheetName(sb.toString());
        }

        if (sizeEN + sizeZH + 2 > 31) {
            int offset = 31 - sizeEN - 5;
            if (offset <= 0) {
                nameZH = "";
            } else {
                nameZH = nameZH.substring(0, offset);
                nameZH = nameZH + "...";
            }
        }
        //BOM信息维护(DataEntry_tbds_bom_maintenance)
        sb.append(nameZH).append("(").append(nameEN).append(")");
        return replaceIllegalSheetName(sb.toString());
    }

    /**
     * 默认替换为"_"
     *
     * @param sheetName
     * @return
     */
    private static String replaceIllegalSheetName(String sheetName) {
        return sheetName.replaceAll("[:\\\\/\\?\\*\\[\\]]", "_");
    }

    /**
     * 自主选择字符串
     *
     * @param sheetName
     * @param replaceCharacter
     * @return
     */
    private static String replaceIllegalSheetName(String sheetName, String replaceCharacter) {
        String illegalCharacters = "[:]\\/?*";
        if (replaceCharacter.length() > 1 || illegalCharacters.contains(replaceCharacter)) {
            return replaceIllegalSheetName(sheetName);
        }
        return sheetName.replaceAll("[:\\\\/\\?\\*\\[\\]]", replaceCharacter);
    }

    public static void main(String[] args) {
        System.out.println(replaceIllegalSheetName("abbddddf?e", "-"));
        System.out.println(replaceIllegalSheetName("abbddddf?e", "]"));
        System.out.println(replaceIllegalSheetName("abbddddf?e", "]]]]"));

        //英文长度超过29
        //英文长度超过25，没有加省略号...的意义

        System.out.println("原本：  " + "BOM信息维护(DataEntry_tbds_bom_maintenance)");
        //en:31
        System.out.println("英文长度:" + "DataEntry:tbds?bom[maintenancei".length() + "  " + getSheetName("DataEntry:tbds?bom[maintenancei", "BOM信息维护", true) + " size:" + getSheetName("DataEntry:tbds?bom[maintenancei", "BOM信息维护", true).length());
        //en：30
        System.out.println("英文长度:" + "DataEntry:tbds?bom[maintenance".length() + "  " + getSheetName("DataEntry:tbds?bom[maintenance", "BOM信息维护", true) + " size:" + getSheetName("DataEntry:tbds?bom[maintenance", "BOM信息维护", true).length());
        //en:29
        System.out.println("英文长度:" + "DataEntry:tbds?bom[maintenanc".length() + "  " + getSheetName("DataEntry:tbds?bom[maintenanc", "BOM信息维护", true) + " size:" + getSheetName("DataEntry:tbds?bom[maintenanc", "BOM信息维护", true).length());
        //en: 25
        System.out.println("英文长度:" + "DataEntry_tbds_bom_mainte".length() + " " + getSheetName("DataEntry_tbds_bom_mainte", "BOM信息维护", true) + " size:" + getSheetName("DataEntry_tbds_bom_mainte", "BOM信息维护", true).length());
        //en: 20
        System.out.println("英文长度:" + "DataEntry_tbds_bom_m".length() + " " + getSheetName("DataEntry_tbds_bom_m", "BOM信息维护", true) + " size:" + getSheetName("DataEntry_tbds_bom_m", "BOM信息维护", true).length());
        //en: 22
        System.out.println("英文长度:" + "DataEntry_tbds_bom_main".length() + " " + getSheetName("DataEntry_tbds_bom_main", "BOM信息维护", true) + " size:" + getSheetName("DataEntry_tbds_bom_main", "BOM信息维护", true).length());
        //en: 26
        System.out.println("英文长度：" + "DataEntry_tbds_bom_mainten".length() + " " + getSheetName("DataEntry_tbds_bom_mainten", "BOM信息维护", true) + " size:" + getSheetName("DataEntry_tbds_bom_mainten", "BOM信息维护", true).length());

        //获取原本的sheetName
//        System.out.println("BOM信息维护（DataEntry_tbds_bom_maintenance）"+getSheetNameInParens("BOM信息维护(DataEntry_tbds_bom_maintenance)"));
//        System.out.println("BOM信息维护（DataEntry_tbds_bom_maintenance）"+getSheetNameInParens("BOM信息维护（DataEntry_tbds_bom_maintenance）"));
//        System.out.println("BOM信息维护（DataEntry_tbds_bom_maintenance）"+getSheetNameInParens("BOM信息维护（DataEntry_tbds_bom_maintenance)"));

    }

    /**
     * 创建工作簿
     *
     * @return
     */
    public SXSSFWorkbook createSXSSFWorkbook() {
        XSSFWorkbook xssfwb = new XSSFWorkbook();
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            xssfwb.write(bos);
        } catch (IOException e) {
            log.error("转换multipartfile失败:{}", e);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0076.getErrCode(), "转换multipartFile失败:{}", e);
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    log.error("Exception occurred", e);
                }
            }
        }

        // 使用SXSSFWorkbook只会保留100条数据在内存中，其它的数据都会写到磁盘里，减少内存占用
        SXSSFWorkbook sxssfwb = new SXSSFWorkbook(xssfwb, JaProperty.getInteger(RedisQueueContant.SXSSFWORKBOOK_MEMORY_SIZE, 100));
        return sxssfwb;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String tmpDir = System.getProperty(JAVA_IO_TMPDIR);
        if (tmpDir == null) {
            throw new IOException("Systems temporary directory not defined - set the -D" + JAVA_IO_TMPDIR + " jvm property!");
        }
        File dir = new File(tmpDir, POIFILES);

        // create directory if it doesn't exist
        final boolean dirExists = (dir.exists() || dir.mkdirs());

        if (!dirExists) {
            throw new IOException("Could not create temporary directory '" + dir + "'");
        } else if (!dir.isDirectory()) {
            throw new IOException("Could not create temporary directory. '" + dir + "' exists but is not a directory.");
        }
    }

    public boolean isWorkbookEmpty(SXSSFWorkbook sxssfwb) {
        for (int i = 0; i < sxssfwb.getNumberOfSheets(); i++) {
            SXSSFSheet sheet = sxssfwb.getSheetAt(i);
            // 关键点：getLastRowNum()返回最后一个有数据的行索引（从0开始），若无数据则返回-1
            if (sheet.getLastRowNum() > 1) {
                return false; // 发现有效行，工作簿非空
            }
        }
        return true; // 所有工作表均无数据
    }

    /**
     * 克隆源工作簿中的一个Sheet到目标工作簿中
     *
     * @param sourceWorkbook 源工作簿
     * @param targetWorkbook 目标工作簿
     * @param sheetName      要克隆的Sheet名称
     * @throws IllegalArgumentException 如果源Sheet不存在或目标Workbook中已存在同名Sheet
     */
    public static int cloneSheet(SXSSFWorkbook sourceWorkbook, SXSSFWorkbook targetWorkbook, String sheetName) {
        // 检查源Sheet是否存在
        SXSSFSheet sourceSheet = sourceWorkbook.getSheet(sheetName);
        if (sourceSheet == null) {
            throw new IllegalArgumentException("源Sheet不存在: " + sheetName);
        }

        // 检查目标Sheet是否已存在
        if (targetWorkbook.getSheet(sheetName) != null) {
            throw new IllegalArgumentException("目标Workbook中已存在同名Sheet: " + sheetName);
        }

        // 在目标工作簿中创建新Sheet
        SXSSFSheet targetSheet = targetWorkbook.createSheet(sheetName);
        // 用于缓存样式，避免重复创建相同的样式
        Map<CellStyle, CellStyle> styleMap = new IdentityHashMap<>();

        // 克隆每一行（包括空行）
        int lastRowNum = sourceSheet.getLastRowNum();

        for (int i = 0; i <= lastRowNum; i++) {
            Row sourceRow = sourceSheet.getRow(i);
            Row targetRow = targetSheet.createRow(i);

            if (sourceRow != null) {
                // 设置行高
                targetRow.setHeight(sourceRow.getHeight());

                // 克隆每个单元格
                for (Cell sourceCell : sourceRow) {
                    Cell targetCell = targetRow.createCell(sourceCell.getColumnIndex());
                    cloneCell(sourceCell, targetCell, targetWorkbook, styleMap);
                }
            }
        }

        // 设置列宽（使用首行确保有数据）
        Row firstRow = sourceSheet.getRow(sourceSheet.getFirstRowNum());
        if (firstRow != null && firstRow.getLastCellNum() > 0) {
            for (int i = 0; i < firstRow.getLastCellNum(); i++) {
                targetSheet.setColumnWidth(i, sourceSheet.getColumnWidth(i));
            }
        }

        // 处理合并单元格（去重）
        for (int i = 0; i < sourceSheet.getNumMergedRegions(); i++) {
            CellRangeAddress region = sourceSheet.getMergedRegion(i);
            boolean exists = false;
            for (int j = 0; j < targetSheet.getNumMergedRegions(); j++) {
                if (targetSheet.getMergedRegion(j).equals(region)) {
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                targetSheet.addMergedRegion(region);
            }
        }
        return lastRowNum;
    }

    /**
     * 克隆单元格，包括内容、样式、注释和超链接
     *
     * @param sourceCell 源单元格
     * @param targetCell 目标单元格
     * @param targetWorkbook 目标工作簿
     * @param styleMap 用于缓存样式的Map
     */
    private static void cloneCell(Cell sourceCell, Cell targetCell, SXSSFWorkbook targetWorkbook, Map<CellStyle, CellStyle> styleMap) {
        // 根据单元格类型设置内容
        switch (sourceCell.getCellTypeEnum()) {
            case STRING:
                targetCell.setCellValue(sourceCell.getStringCellValue());
                break;
            case NUMERIC:
                targetCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            case BOOLEAN:
                targetCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            case FORMULA:
                targetCell.setCellFormula(sourceCell.getCellFormula());
                break;
            case BLANK:
                targetCell.setCellType(CellType.BLANK);
                break;
            default:
                break;
        }

        // 复制样式
        if (sourceCell.getCellStyle() != null) {
            CellStyle sourceStyle = sourceCell.getCellStyle();
            CellStyle targetStyle = styleMap.computeIfAbsent(sourceStyle, s -> createMatchingCellStyle(s, targetWorkbook));
            targetCell.setCellStyle(targetStyle);
        }

        // 复制注释
        if (sourceCell.getCellComment() != null) {
            targetCell.setCellComment(sourceCell.getCellComment());
        }

        // 复制超链接
        if (sourceCell.getHyperlink() != null) {
            targetCell.setHyperlink(sourceCell.getHyperlink());
        }
    }

    /**
     * 创建一个与源样式匹配的目标样式
     *
     * @param sourceStyle 源样式
     * @param targetWorkbook 目标工作簿
     * @return 新创建的样式
     */
    private static CellStyle createMatchingCellStyle(CellStyle sourceStyle, SXSSFWorkbook targetWorkbook) {
        CellStyle targetStyle = targetWorkbook.createCellStyle();
        targetStyle.cloneStyleFrom(sourceStyle);
        return targetStyle;
    }

}
