package com.digiwin.athena.abt.application.service.abt.migration.helpler.validation;

import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.excel.convert.StringConversionUtils;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 数据格式校验
 *
 * @Auther: lisheng
 * @Date: 2024/12/3 14:06
 * @Description:
 */
public class DataFormatDataValidation extends DataValidationAbstract {

    @Override
    public String getType() {
        return DataValidationConstant.DATA_FORMAT_DATA_VALIDATION_TYPE;
    }

    @Override
    public String validate(Object rule, Object data, String locale) {
        String errorMsg = super.validate(rule, data, locale);
        CellTypeContainer cellTypeContainer = (CellTypeContainer) rule;
        Map.Entry<String, Object> cellEntry = (Map.Entry<String, Object>) data;
        if (null == cellTypeContainer) {
            return errorMsg;
        }
        Object cellValue = cellEntry.getValue();
        // 校验数据格式时，如果单元格值为空，则不进行校验
        if (null == cellValue || (cellValue instanceof String && ((String) cellValue).isEmpty())) {
            return errorMsg;
        }
        MetaDataType metaDataType = cellTypeContainer.getProtoType();
        switch (metaDataType) {
            case STRING:
                if ((null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0)) {
                    int max = (null != cellTypeContainer.getPrecision() && cellTypeContainer.getPrecision().length != 0) ? cellTypeContainer.getPrecision()[0] : Integer.MAX_VALUE;
                    if (cellValue.toString().length() > max) {
                        errorMsg = MessageUtil.getMessageByLocale("excel.string.content.length", locale, max);
                    }
                }
                break;
            case NUMBER:
                if (!(cellValue instanceof Number)) {
                    errorMsg = MessageUtil.getMessageByLocale("excel.number.content.isNumber", locale);
                }
                break;
            case NUMERIC:
                if (cellValue instanceof String) {
                    String stringValue = (String) cellValue;
                    if (!StringConversionUtils.isNumericBigDecimal(stringValue)) {
                        errorMsg = MessageUtil.getMessageByLocale("excel.number.content.isNumber", locale);
                    }
                }
                break;
            case TIME:
            case DATETIME:
            case DATE:
                if (!ExcelUtil.isValidDate(cellValue.toString(), cellTypeContainer.getDateFormat())) {
                    errorMsg = MessageUtil.getMessageByLocale("excel.date.content.enterCorrect", locale, cellTypeContainer.getDateFormat());
                }
                break;
            case BOOLEAN:
                if (!(cellValue instanceof Boolean)) {
                    List<String> enumList = Arrays.asList(cellTypeContainer.getListEnum());
                    if (!enumList.contains(cellValue)) {
                        errorMsg = MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, enumList.toString());
                    }
                }
                break;
            case ENUM:
                if (null != cellTypeContainer.getListEnum() && cellTypeContainer.getListEnum().length != 0) {
                    List<String> enumList = Arrays.asList(cellTypeContainer.getListEnum());
                    List<String> enumCodes = getEnumCodes(enumList);
                    if (!enumCodes.contains(cellValue)) {
                        errorMsg = MessageUtil.getMessageByLocale("excel.select.content.selectCorrect", locale, enumList.toString());
                    }
                }
                break;
            default:
                break;
        }
        return errorMsg;
    }

    /**
     * 获取枚举code
     *
     * @param enumList
     * @return
     */
    private List<String> getEnumCodes(List<String> enumList) {
        List<String> enumCodes = new ArrayList<>();
        for (String enumStr : enumList) {
            int index = enumStr.lastIndexOf(".");
            String code;
            if (index > 0) {
                code = enumStr.substring(0, index);
            } else {
                code = enumStr;
            }
            enumCodes.add(code);
        }
        return enumCodes;
    }
}
