package com.digiwin.athena.abt.application.service.abt.migration.helpler.validation;

/**
 * @Auther: lisheng
 * @Date: 2024/12/3 15:07
 * @Description:
 */
public enum DataValidationEnum {

    REQUIRED(DataValidationConstant.REQUIRED_DATA_VALIDATION_TYPE, new RequiredDataValidation()),
    FORMAT(DataValidationConstant.DATA_FORMAT_DATA_VALIDATION_TYPE, new DataFormatDataValidation());

    /**
     * 校验类型
     */
    private final String type;

    /**
     * 数据校验类
     */
    private final DataValidation dataValidation;

    DataValidationEnum(String type, DataValidation dataValidation) {
        this.type = type;
        this.dataValidation = dataValidation;
    }

    /**
     * 获取校验类
     * @param type
     * @return
     */
    public static DataValidation getDataValidation(String type) {
        for (DataValidationEnum dataValidationEnum : DataValidationEnum.values()) {
            if (dataValidationEnum.getType().equals(type)) {
                return dataValidationEnum.dataValidation;
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }
}
