package com.digiwin.athena.abt.application.service.abt.migration.helpler.validation;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Set;

/**
 * 必填校验
 * @Auther: lisheng
 * @Date: 2024/12/3 14:06
 * @Description:
 */
public class RequiredDataValidation extends DataValidationAbstract {

    @Override
    public String getType() {
        return DataValidationConstant.REQUIRED_DATA_VALIDATION_TYPE;
    }

    @Override
    public String validate(Object rule, Object data, String locale) {
        String errorMsg = super.validate(rule, data, locale);
        Set<String> requiredFiled = (Set<String>) rule;
        Map.Entry<String,Object> cellEntry = (Map.Entry<String, Object>) data;
        if(CollectionUtils.isEmpty(requiredFiled) || !requiredFiled.contains(cellEntry.getKey())){
            return errorMsg;
        }

        if(null == cellEntry.getValue()){
            return MessageUtil.getMessageByLocale("upload.miss.filed.error", locale);
        }

        if(cellEntry.getValue() instanceof String && ((String) cellEntry.getValue()).trim().isEmpty()){
            return MessageUtil.getMessageByLocale("upload.miss.filed.error", locale);
        }
        return errorMsg;
    }
}
