package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.api.*;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.*;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.dto.request.UploadBatchFileReq;
import com.digiwin.athena.abt.application.dto.request.UploadBatchReq;
import com.digiwin.athena.abt.application.utils.DataEntryTaskUtils;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.IEService;
import com.digiwin.athena.abt.core.ie.contants.ExeclErrorCodeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportTaskTypeEnum;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainTask;
import com.digiwin.athena.abt.core.ie.excel.model.ExcelReadOptions;
import com.digiwin.athena.abt.core.ie.excel.reader.IEExcelReader;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;

import static com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants.BASIC_DATA_BIZ_TYPE;

/**
 * @Description 基础数据录入新方法基于redis
 **/
@Slf4j
@Service
public class BaseDataEntryRedisService {

    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;

    @Autowired
    private MetaDataService metaDataService;

    @Autowired
    private IEService exportService;

    @Autowired
    private IEExcelReader ieExcelReader;

    @Autowired
    private ImportStatisticsDomainService importStatisticsDomainService;

    @Resource
    private DmcService dmcService;

    @Autowired
    private ExportBatchRecordService exportBatchRecordService;

    /**
     * @Description 发起异步下载（目前不需要添加事物）
     * @Date 13:31 2023/9/20
     * @Param
     **/
    public Boolean startDownload(DownloadBaseDataParamDTO downloadBaseDataParamDTO) {
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setId(SnowflakeIdWorker.getInstance().newId());
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setExportParams(JsonUtils.objectToString(downloadBaseDataParamDTO));
        exportStatistics.setActivityId(downloadBaseDataParamDTO.getActionInfo().getCode());
//        String type = Optional.ofNullable(downloadBaseDataParamDTO.getType()).orElse("default");
        exportStatistics.setType(ImportAndExportStatisticsConstants.EXPORT_FILE_TYPE_BUSINESS_DATA);
        //根据activityId获取activityName多语言信息
        String activityName = metaDataService.getActivityNameByActivityId(exportStatistics.getActivityId(), null);
        exportStatistics.setActivityName(activityName);
        exportStatistics.setActionId(downloadBaseDataParamDTO.getActionInfo().getActionId());
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(downloadBaseDataParamDTO.getActionInfo().getFileName());
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        //冗余用户对象
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString(simpleUser));
        // 设置失效时间为5天后
        exportStatistics.setExpireTime(DateUtils.addDays(now, ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        exportStatistics.setTotalSize(0);
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setActionId(exportStatistics.getActionId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setDownloadBaseDataParamDTO(downloadBaseDataParamDTO);
        //加密密码
        Optional.ofNullable(downloadBaseDataParamDTO).map(DownloadBaseDataParamDTO::getActionInfo).map(ActionInfoDTO::getDefence)
                .filter(StringUtils::isNotBlank).ifPresent(exportStatistics::setDefence);

        // 1、更新导入记录
        //更新对应masterId处理消息条数
        int insertResult = exportStatisticsDomainService.insertByMasterId(exportStatistics);

        // 2、发送MQ异步处理
        if (insertResult == 1) {
            exportBatchRecordService.splitBaseDataEntry(downloadBaseDataParamDTO,exportStatistics);
            return sendExportFileMq(exportFileMsg, exportStatistics);
        } else {
            return false;
        }
    }

    private Boolean sendExportFileMq(ExportFileMsg exportFileMsg, ExportStatistics exportStatistics) {
        log.info("enter sendExportFileMQ");
        if (Objects.isNull(exportFileMsg)) {
            log.error("exportFileMsg is null");
            return Boolean.FALSE;
        }
        String mainTaskId = JaUUID.UUID19();
        try {
            IERedisMainTask mainTask = new IERedisMainTask();
            mainTask.setMainTaskId(mainTaskId);
            mainTask.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            mainTask.setReceiveTime(new Date());
            mainTask.setTimeOut(JaProperty.getInteger(RedisQueueContant.BASE_REDIS_QUEUE_TIMEOUT, 60 * 60));

            exportFileMsg.setTenantId(exportFileMsg.getTenantId());
            exportFileMsg.setMainTaskId(mainTaskId);
            exportFileMsg.setSubTaskId(exportFileMsg.getMasterId());
            exportFileMsg.setBusinessType(IEExportBusinessTypeEnum.BASIC.getType());
            exportFileMsg.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            exportFileMsg.setTaskClazz(ExportFileMsg.class.getName());
            exportFileMsg.setReceiveTime(new Date());
            exportFileMsg.setTimeOut(JaProperty.getInteger(RedisQueueContant.BASE_REDIS_QUEUE_TIMEOUT, 60 * 60));

            mainTask.setSubTaskList(Lists.newArrayList(exportFileMsg));
            exportService.submit(mainTask);
            log.info("send msg success mainTaskId:{},masterId:{}", mainTaskId, exportFileMsg.getMasterId());
        } catch (Exception e) {
            log.error("send msg Exception mainTaskId:{},masterId:{}", mainTaskId, exportFileMsg.getMasterId(), e);
            //更新记录
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportStatisticsDomainService.updateById(exportStatistics);
        }
        return Boolean.TRUE;
    }

    public void uploadBatch(UploadBatchReq uploadBatchReq, Map<Integer, UploadBatchFileReq> fileUidMap) {
//        String appCode = themeMapService.getAppCode("activity", uploadBatchReq.getActivityId());
        UploadParamDTO uploadParam = new UploadParamDTO();
        uploadParam.setActionId(uploadBatchReq.getActionId());
        uploadParam.setActivityId(uploadBatchReq.getActivityId());
        uploadParam.setRequiredFields(uploadBatchReq.getRequiredFields());
        uploadParam.setActionInfo(JsonUtils.jsonToObject(uploadBatchReq.getActionInfo(), ActionInfoDTO.class));
//        uploadParam.setApplication(appCode);

        List<UploadBatchFileReq> files = uploadBatchReq.getFiles();
        for (int i = 0; i < files.size(); i++) {
            UploadBatchFileReq uploadBatchFileReq = files.get(i);
            uploadParam.setFileName(uploadBatchFileReq.getFileName());
            uploadParam.setFileUid(fileUidMap.get(i).getFileUid());
            ExcelReadOptions<Map<Integer, Object>> options = ExcelReadOptions.<Map<Integer, Object>>builder()
                    .headRowNumber(2)
                    .param(uploadParam)
                    .ignoreEmptyRow(true)
                    .isReadAll(true)
                    .build();
            BasicDataReadListener read = (BasicDataReadListener) ieExcelReader.read(dmcService.getExportFileInputStream(uploadBatchFileReq.getFileUrl()), options, BASIC_DATA_BIZ_TYPE);

            DataEntryTask dataEntryTask = read.getDataEntryTask();
            Date createTime = read.getCreateTime();

            List<ImportBatchRecord> importBatchRecords = DataEntryTaskUtils.processImportBatchRecord(dataEntryTask, createTime);
            if (CollectionUtils.isEmpty(dataEntryTask.getBatchInfos())) {
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0107.getErrCode(), MessageUtil.getMessage("delivery.handleDataError"));
            }

            importStatisticsDomainService.saveImportStatisticsAndRecord((UploadParamDTO) read.getParam(), read.getActivityName(),
                    read.getRecordCounter().intValue(), importBatchRecords, createTime);

            sendMsg(read.getMasterId(), dataEntryTask);
        }
    }

    private void sendMsg(String masterId, DataEntryTask dataEntryTask) {
        log.info("[基础资料导入]enter send batch");
        if (null == dataEntryTask || org.apache.commons.collections.CollectionUtils.isEmpty(dataEntryTask.getBatchInfos())) {
            return;
        }

        String mainTaskId = JaUUID.UUID19();
        try {
            IERedisMainTask mainTask = new IERedisMainTask();
            mainTask.setMainTaskId(mainTaskId);
            mainTask.setTaskType(IEExportTaskTypeEnum.IMPORT.getType());
            mainTask.setReceiveTime(new Date());
            mainTask.setTimeOut(JaProperty.getInteger(RedisQueueContant.BASE_IMPORT_REDIS_QUEUE_TIMEOUT, 60 * 60));

            dataEntryTask.setTenantId(dataEntryTask.getTenantId());
            dataEntryTask.setMainTaskId(mainTaskId);
            dataEntryTask.setSubTaskId(dataEntryTask.getMasterId());
            dataEntryTask.setBusinessType(IEExportBusinessTypeEnum.BASIC_IMPORT.getType());
            dataEntryTask.setTaskType(IEExportTaskTypeEnum.IMPORT.getType());
            dataEntryTask.setTaskClazz(DataEntryTask.class.getName());
            dataEntryTask.setReceiveTime(new Date());
            dataEntryTask.setTimeOut(JaProperty.getInteger(RedisQueueContant.BASE_IMPORT_REDIS_QUEUE_TIMEOUT, 60 * 60));

            mainTask.setSubTaskList(Lists.newArrayList(dataEntryTask));
            exportService.submit(mainTask);
            log.info("[基础资料导入]send msg success mainTaskId:{},masterId:{}", mainTaskId, dataEntryTask.getMasterId());
        } catch (Exception e) {
            log.error("[基础资料导入]send msg Exception mainTaskId:{},masterId:{}", mainTaskId, dataEntryTask.getMasterId(), e);
            importStatisticsDomainService.updateImportStatisticsAndRecord(masterId, dataEntryTask);
        }
    }

    public void checkUploadParams(UploadBatchReq uploadBatchReq, Map<Integer, UploadBatchFileReq> fileUidMap) {
        if (Objects.equals(1, uploadBatchReq.getIsReImport())) {
            return;
        }
        Map<String, ImportStatistics> statsCache = new HashMap<>(fileUidMap.size());

        for (UploadBatchFileReq fileReq : fileUidMap.values()) {
            String fileUid = fileReq.getFileUid();
            // 查询并缓存结果（避免重复查询）
            ImportStatistics stat = statsCache.computeIfAbsent(fileUid, uid -> importStatisticsDomainService.queryImportStatisticsByFileUid(fileUid));
            if (stat == null) {
                continue;
            }

            Integer processingNum = stat.getProcessingNum();
            // 检查处理中的文件（优先级最高）
            if (processingNum != null && processingNum != 0) {
                //文件前一次导入尚未成功，又进行导入：“【xxx】导入处理中，请勿再次操作”
                throw ExeclErrorCodeEnum.CHECK_EXECL_FILE_IMPORTED_PROCESSING.getBusinessExceptionWithArgs(fileReq.getFileName());
            }
        }

        // 检查已成功导入的文件（仅当没有处理中文件时执行）
        for (UploadBatchFileReq fileReq : fileUidMap.values()) {
            ImportStatistics stat = statsCache.get(fileReq.getFileUid());
            if (stat == null) {
                continue;
            }

            Integer processingNum = stat.getProcessingNum();
            if (processingNum != null && processingNum == 0) {
                //前一次导入成功后，又导入相同的数据：“检测到您已在 2025-06-05 14:32 导入过[xxxxx]文件，是否重新导入？”时间为上次导入成功的时间。
                throw ExeclErrorCodeEnum.CHECK_EXECL_FILE_IMPORTED_SUCCESS.getBusinessExceptionWithArgs(DateUtil.formatDateTime(stat.getUpdateTime()), fileReq.getFileName());
            }
        }
    }
}

