package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.dto.migration.abt.inout.ErrorTable;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @ClassName ErrorHandlerService
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/25 16:03
 * @Version 1.0
 **/
public interface ErrorHandlerService {

    void handleErrorList(ImportStatistics importStatistics, List<Map> errorTable, boolean createQueueFlag) throws IOException;

    ErrorTable getErrorTableByMasterId(String mainKeyName, ImportStatistics importStatistics, Map<String, CellTypeContainer> cellTypeContainerMap, List<String> mainKeys);

    void downloadErrorTable(ImportStatistics importStatistics, List<Map> headers, Set<String> requiredFields, HttpServletResponse response);

    String onImportFinish(String sheetName,List<String> keyList, Map<String, CellTypeContainer> cellTypes, Map<String, String> metaData, ImportStatistics importStatistics);

    public MultipartFile workbookToMultipartFile(Workbook wb, String fileName) throws IOException;

    public MultipartFile workbookToZipFile(Workbook wb, String fileName) throws IOException;

    public String upload(MultipartFile uploadFile, FileInfo fileInfo);

    String uploadFileToHttpServer(File file, FileInfo fileInfo);
}
