package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.dto.migration.abt.api.ActionInfoDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadBaseDataParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionLocaleResponseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.GetActionResponseLocaleResponseDTO;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityToken;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class ExportBatchRecordService {
    @Resource
    private ExportBatchRecordMapper recordMapper;

    @Autowired
    private MetaDataService metaDataService;

    public void splitBaseDataEntry(DownloadBaseDataParamDTO downloadBaseDataParamDTO, ExportStatistics exportStatistics){
        if("split".equals(downloadBaseDataParamDTO.getExportMode())) {
            String userToken = exportStatistics.getUserToken();
            DWSecurityToken dwSecurityToken;
            try {
                dwSecurityToken = DWSecurityTokenGenerator.parseSecurityToken(userToken);
            } catch (Exception e) {
                log.error("解析token失败:{}", userToken);
                // 抛异常，在catch中统一处理
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0106.getErrCode(), MessageUtil.getMessage("delivery.resolveTokenError"), e);
            }
            GetActionLocaleResponseDTO metadataDTO = metaDataService.getActionMetaDataBySecurityToken(exportStatistics.getActionId(), dwSecurityToken.getContext().getUserToken(), exportStatistics.getLocale(), userToken);
            List<String> recordNames = Lists.newArrayList();
            addExportBatchRecord(recordNames,metadataDTO);
            if(recordNames.size()>1){
                Date now = new Date();
                ActionInfoDTO actionInfo = downloadBaseDataParamDTO.getActionInfo();
                for (String recordName : recordNames) {
                    ExportBatchRecordPO exportBatchRecord = new ExportBatchRecordPO();
                    exportBatchRecord.setMasterId(exportStatistics.getMasterId());
                    exportBatchRecord.setBatchSeq(0);
                    exportBatchRecord.setType("0");
                    exportBatchRecord.setRelate(null);
                    exportBatchRecord.setExportParams(null);
                    exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
                    exportBatchRecord.setCreateTime(now);
                    exportBatchRecord.setUpdateTime(now);
                    exportBatchRecord.setCode(actionInfo.getCode());
                    exportBatchRecord.setFileName(recordName);
                    exportBatchRecord.setTenantId(exportStatistics.getTenantId());
                    exportBatchRecord.setName(exportStatistics.getActivityName());
                    recordMapper.insert(exportBatchRecord);
                }
            }
        }
    }
    private void addExportBatchRecord(List<String> recordName,GetActionLocaleResponseDTO actionLocaleResponseDTO){
        GetActionResponseLocaleResponseDTO response = actionLocaleResponseDTO.getResponse();
        ApiDataFieldLocaleMetadataDTO data = response.getData();
        recordName.add(data.getDescription());
        List<ApiDataFieldLocaleMetadataDTO> field = data.getField();
        if(CollectionUtils.isNotEmpty(field)){
            field.forEach(e->{
                if(e.getIs_array()){
                    recordName.add(e.getDescription());
                }
            });
        }
    }

}
