package com.digiwin.athena.abt.application.service.abt.migration.inout;

import cn.hutool.core.convert.Convert;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.*;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;

import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;

import com.digiwin.athena.abt.core.ie.IEService;
import com.digiwin.athena.abt.core.ie.contants.IEExportBusinessTypeEnum;
import com.digiwin.athena.abt.core.ie.contants.IEExportTaskTypeEnum;
import com.digiwin.athena.abt.core.ie.dto.IERedisMainTask;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description 历史项目任务导出
 **/
@Slf4j
@Service
public class ExportHistoryDataRedisService {
    @Autowired
    private ExportStatisticsDomainService exportStatisticsDomainService;

    @Autowired
    private IEService exportService;

    /**
     * 发起异步下载 历史项目/任务
     *
     * @param paramMap
     * @return
     */
    public Boolean historyStartDownload(Map<String, Object> paramMap) {
        String fileName = "";
        Map<String, Object> historydDataInfoMap = MapUtils.getMap(paramMap, "historydDataInfo", new HashMap());
        String fileNameParam = MapUtils.getString(historydDataInfoMap, "fileName", "");
        if (StringUtils.isNotEmpty(fileNameParam)) {
            fileName = fileNameParam;
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            fileName = "历史项目任务_" + sdf.format(new Date());
        }
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setId(SnowflakeIdWorker.getInstance().newId());
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setType(ImportAndExportStatisticsConstants.EXPORT_FILE_TYPE_HISTORY_DATA);
        //由于增加了历史任务项目导出，前端和业务数据导出用的同一个组件  所以后端这里取activityName作为导出的作业名称
        exportStatistics.setActivityName("{\"default\":\"历史项目任务\",\"zh_TW\":\"歷史項目任務\",\"en_US\":\"history project|task\",\"zh_CN\":\"历史项目任务\"}");
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(fileName);
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        //冗余用户对象
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString(simpleUser));
        // 设置失效时间为5天后
        exportStatistics.setExpireTime(DateUtils.addDays(now, ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        exportStatistics.setTotalSize(0);

        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setHistoryDownloadBaseDataParam(paramMap);

        //添加压缩密码
        Optional.ofNullable(paramMap).map(t -> t.get("defence")).map(Convert::toStr).filter(StringUtils::isNotBlank)
                .ifPresent(exportStatistics::setDefence);

        // 更新导入记录
        int insertResult = exportStatisticsDomainService.insertByMasterId(exportStatistics);

        if (insertResult == 1) {
            return sendExportFileMq(exportFileMsg, exportStatistics);
        } else {
            return false;
        }
    }

    private Boolean sendExportFileMq(ExportFileMsg exportFileMsg, ExportStatistics exportStatistics) {
        log.info("enter sendExportFileMQ");
        if (Objects.isNull(exportFileMsg)) {
            log.error("exportFileMsg is null");
            return Boolean.FALSE;
        }
        String mainTaskId = JaUUID.UUID19();
        try {
            IERedisMainTask mainTask = new IERedisMainTask();
            mainTask.setMainTaskId(mainTaskId);
            mainTask.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            mainTask.setReceiveTime(new Date());
            mainTask.setTimeOut(JaProperty.getInteger(RedisQueueContant.HISTORY_REDIS_QUEUE_TIMEOUT, 60 * 60));

            exportFileMsg.setTenantId(exportFileMsg.getTenantId());
            exportFileMsg.setMainTaskId(mainTaskId);
            exportFileMsg.setSubTaskId(exportFileMsg.getMasterId());
            exportFileMsg.setBusinessType(IEExportBusinessTypeEnum.HISTORY.getType());
            exportFileMsg.setTaskType(IEExportTaskTypeEnum.EXPORT.getType());
            exportFileMsg.setTaskClazz(ExportFileMsg.class.getName());
            exportFileMsg.setReceiveTime(new Date());
            exportFileMsg.setTimeOut(JaProperty.getInteger(RedisQueueContant.HISTORY_REDIS_QUEUE_TIMEOUT, 60 * 60));
            mainTask.setSubTaskList(Lists.newArrayList(exportFileMsg));
            exportService.submit(mainTask);
            log.info("send msg success mainTaskId:{},masterId:{}", mainTaskId, exportFileMsg.getMasterId());
        } catch (Exception e) {
            log.error("send msg Exception mainTaskId:{},masterId:{}", mainTaskId, exportFileMsg.getMasterId(), e);
            //更新记录
            exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_FAIL);
            exportStatisticsDomainService.updateById(exportStatistics);
        }
        return Boolean.TRUE;
    }
}

