package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.configuration.DMCConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.DMCTokenBean;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.UserStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.FileInfo;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.AppPermissionUtil;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelperV2;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.core.meta.constants.RedisQueueContant;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.ExcelTypeEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName ExportStatisticsDomainService
 * @Description 导出数据领域服务
 * @Author lisheng
 * @Date 2023/9/20 17:51
 * @Version 1.0
 **/
@Slf4j
@Service
public class ExportStatisticsDomainService {

    @Autowired
    ExportStatisticsRepositoryFacade exportStatisticsRepositoryFacade;

    @Autowired
    ExcelHelper excelHelper;

    @Autowired
    ExcelHelperV2 excelHelperV2;

    @Autowired
    private AppPermissionUtil appPermissionUtil;

    @Autowired
    ExportStatisticsFactory exportStatisticsFactory;

    @Autowired
    @Qualifier("rabbitErrorHandlerServiceImpl")
    ErrorHandlerService errorHandlerService;

    @Autowired
    DMCConfig dmcConfig;

    @Autowired
    DMCTokenBean dmcTokenBean;

    @Autowired
    DmcService dmcService;
    private static final String EXCEL_SUFFIX = ".xlsx";

    public int insertByMasterId(ExportStatistics exportStatistics) {
        ExportStatisticsPO exportStatisticsPO = exportStatisticsFactory.getImportStatisticsPO(exportStatistics);
        return exportStatisticsRepositoryFacade.save(exportStatisticsPO);
    }

    public void updateRetryDownloadState(String masterId) {
        exportStatisticsRepositoryFacade.updateRetryDownloadStateById(masterId);
    }

    public ExportStatistics getByMasterId(String masterId) {
        ExportStatisticsPO exportStatisticsPO = exportStatisticsRepositoryFacade.getByMasterId(masterId);
        return null == exportStatisticsPO ? null : exportStatisticsFactory.getExportStatistics(exportStatisticsPO);
    }

    public void updateById(ExportStatistics exportStatistics) {
        if (null == exportStatistics) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0063.getErrCode(), MessageUtil.getMessage("delivery.dataNotFound"));
        }
        ExportStatisticsPO exportStatisticsPO = exportStatisticsFactory.getImportStatisticsPO(exportStatistics);
        exportStatisticsRepositoryFacade.updateById(exportStatisticsPO);
    }

    public void update(ExportStatistics exportStatistics) {
        if (null == exportStatistics) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0063.getErrCode(), MessageUtil.getMessage("delivery.dataNotFound"));
        }
        ExportStatisticsPO exportStatisticsPO = exportStatisticsFactory.getImportStatisticsPO(exportStatistics);
        exportStatisticsRepositoryFacade.updateByStateAndId(exportStatisticsPO, exportStatisticsPO.getId(), ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
    }

    public List<ExportStatistics> getRecordsByUserId(String userId, String tenantId, String locale, GetRecordsParamDTO param) {
        final String loc_default = "default";
        List<ExportStatisticsPO> exportStatisticsPOS = exportStatisticsRepositoryFacade.getRecordsByUserId(userId, tenantId, param.getGetRecordsNum(), param);
        Integer countRecord = exportStatisticsRepositoryFacade.countRecord(userId, tenantId, param);
        exportStatisticsPOS.forEach(e -> e.setQueryPageTotal(countRecord));
        List<ExportStatistics> exportStatisticsList = exportStatisticsFactory.getExportStatisticsList(exportStatisticsPOS, locale);
        Iterator<ExportStatistics> exportStatisticsIterator = exportStatisticsList.iterator();
        while (exportStatisticsIterator.hasNext()) {
            ExportStatistics item = exportStatisticsIterator.next();
            // 存在activityName为null的场景，会导致NPE
            if (item.getActivityName() == null) {
                continue;
            }
            String name;
            Map<String, String> localeMap = JsonUtils.jsonToObject(item.getActivityName(), Map.class);
            if (!StringUtils.isEmpty(locale)) {
                name = null == localeMap.get(locale) ? localeMap.get(loc_default) : localeMap.get(locale);
                item.setActivityName(name);
            } else {
                name = localeMap.get(loc_default);
                item.setActivityName(name);
            }

            // 只查询当前租户下的导入记录
//            if(!tenantId.equals(item.getTenantId())){
//                exportStatisticsIterator.remove();
//            }
        }
        return exportStatisticsList;
    }

    public UserStatistics getProcessingNum(String userId, String tenantId, String type, List<String> types) {
        UserStatistics userStatistics = new UserStatistics();
        userStatistics.setUserId(userId);

        List<ExportStatisticsPO> exportStatisticsPOS = exportStatisticsRepositoryFacade.getProcessingRecordsByUserId(userId, tenantId, type, types);
        if (CollectionUtils.isEmpty(exportStatisticsPOS)) {
            userStatistics.setProcessingNum(0);
            return userStatistics;
        }

        // 1：历史项目任务列表导出、4：历史项目任务明细导出；这两种不存在过滤授权应用的情况
        if ((Objects.nonNull(type) && !"1".equals(type) && !"4".equals(type)) ||
                (!CollectionUtils.isEmpty(types) && !types.contains("1") && !types.contains("4"))) {
            // 过滤授权应用
            List<String> activityIds = exportStatisticsPOS.stream().map(ExportStatisticsPO::getActivityId).distinct().collect(Collectors.toList());
            List<String> hasPermissionActivityCodeList = appPermissionUtil.handleAppPermission(activityIds);
            exportStatisticsPOS = exportStatisticsPOS.stream().filter(x ->
                    hasPermissionActivityCodeList.contains(x.getActivityId())).collect(Collectors.toList());
        }


        userStatistics.setProcessingNum(exportStatisticsPOS.size());
        return userStatistics;
    }

    public String handleDownloadBaseData(ExportStatistics exportStatistics, List<String> keyList, Map<String, String> headers, Map<String, CellTypeContainer> cellTypeContainerMap,
                                         List<Map<String, Object>> tableList, String sheetName) {
        long start;
        MultipartFile multipartFile = null;
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            XSSFWorkbook xssfwb = new XSSFWorkbook();
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                xssfwb.write(bos);
            } catch (IOException e) {
                log.error("转换multipartfile失败:{}", e);
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0076.getErrCode(), "转换multipartFile失败:{}", e);
            } finally {
                if (bos != null) {
                    try {
                        bos.close();
                    } catch (IOException e) {
                        log.error("Exception occurred", e);
                    }
                }
            }

            // 使用SXSSFWorkbook只会保留100条数据在内存中，其它的数据都会写到磁盘里，减少内存占用
            SXSSFWorkbook sxssfwb = new SXSSFWorkbook(xssfwb, ImportAndExportStatisticsConstants.SXSSFWorkbook_MEMORY_SIZE);
            int rowIndex = 2;
            List<CellTypeContainer> businessKeyContainer = excelHelper.getBusinessKeyContainer(new ArrayList<>(cellTypeContainerMap.values()));
            excelHelper.createDataExcel(sheetName, exportStatistics.getLocale(), rowIndex, keyList, cellTypeContainerMap, headers, tableList, sxssfwb, businessKeyContainer, 0, null, null);
            start = System.currentTimeMillis();
            outputStream = new ByteArrayOutputStream();
            sxssfwb.write(outputStream);
            byte[] bytes = outputStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            multipartFile = new MockMultipartFile("file", exportStatistics.getFileName(), ExcelTypeEnum.XLSX.value(), inputStream);
            outputStream.flush();
            sxssfwb.dispose();// 释放workbook所占用的所有windows资源
        } catch (Exception e) {
            log.error("handleDownloadBaseData fail:{}", e);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0076.getErrCode(), "handleDownloadBaseData fail:{}", e);
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    log.error("close outputStream fail:{}", e);
                    log.error("Exception occurred", e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    log.error("close inputStream fail:{}", e);
                    log.error("Exception occurred", e);
                }
            }

        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(exportStatistics.getFileName());
        fileInfo.setDirectoryId(dmcConfig.getErrorTableUUID());
        fileInfo.setExpireDate(TimeUtils.format(exportStatistics.getExpireTime(), TimeUtils.DEFAULT_FORMAT));
        //上传文件至文件服务器
        try {
            return errorHandlerService.upload(multipartFile, fileInfo);
        } finally {
            log.info("老版本上传文件耗时：{}", System.currentTimeMillis() - start);
        }

    }

    public String handleDownloadBaseDataV2(SXSSFWorkbook sxssfwb,FileInfo fileInfo) {
        long start = System.currentTimeMillis();
        Path tempFilePath = null;
        try {
            tempFilePath = Paths.get(MessageFormat.format(RedisQueueContant.TEMP_PATH, JaUUID.UUID19()));

            try (OutputStream os = Files.newOutputStream(tempFilePath)) {
                sxssfwb.write(os);
            }
            sxssfwb.dispose();// 释放workbook所占用的所有windows资源
        } catch (Exception e) {
            log.error("handleDownloadBaseData fail:{}", e);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0076.getErrCode(), "handleDownloadBaseData fail:{}", e);
        }

        try {
//            FileInfo fileInfo = new FileInfo();
//            fileInfo.setDisplayName(fileName);
            fileInfo.setDirectoryId(dmcConfig.getErrorTableUUID());
//            fileInfo.setExpireDate(TimeUtils.format(expireTime, TimeUtils.DEFAULT_FORMAT));
            //上传文件至文件服务器
            return errorHandlerService.uploadFileToHttpServer(new File(String.valueOf(tempFilePath)), fileInfo);
        } catch (Exception e) {
            log.error("handleDownloadBaseData fail:", e);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0076.getErrCode(), "handleDownloadBaseData fail:{}", e);
        } finally {
            // 删除临时文件
            try {
                Files.deleteIfExists(tempFilePath);
                log.info("临时文件已删除: {}", tempFilePath);
            } catch (IOException e) {
                log.error("临时文件删除失败", e);
            }
            log.info("新版本上传文件耗时：{}", System.currentTimeMillis() - start);
        }
    }

    public String handleDownloadBaseDataV3(SXSSFWorkbook sxssfwb, ExportStatistics exportStatistics) {
        int rowIndex = 2;
        MultipartFile multipartFile = null;
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            sxssfwb.write(outputStream);
            byte[] bytes = outputStream.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
            multipartFile = new MockMultipartFile("file", exportStatistics.getFileName(), ExcelTypeEnum.XLSX.value(), inputStream);
            outputStream.flush();
            sxssfwb.dispose();// 释放workbook所占用的所有windows资源
        } catch (Exception e) {
            log.error("handleDownloadBaseData fail:{}", e);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0076.getErrCode(), "handleDownloadBaseData fail:{}", e);
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    log.error("close outputStream fail:{}", e);
                    log.error("Exception occurred", e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    log.error("close inputStream fail:{}", e);
                    log.error("Exception occurred", e);
                }
            }

        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(exportStatistics.getFileName());
        fileInfo.setDirectoryId(dmcConfig.getErrorTableUUID());
        fileInfo.setExpireDate(TimeUtils.format(exportStatistics.getExpireTime(), TimeUtils.DEFAULT_FORMAT));
        //上传文件至文件服务器
        return errorHandlerService.upload(multipartFile, fileInfo);
    }
}
