package com.digiwin.athena.abt.application.service.abt.migration.inout;


import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;

import java.util.List;

/**
 * @ClassName ExportStatisticsRepositoryFacade
 * @Description 导出数据统计仓储外观
 * @Author lisheng
 * @Date 2023/9/20 18:03
 * @Version 1.0
 **/
public interface ExportStatisticsRepositoryFacade {

    int save(ExportStatisticsPO exportStatisticsPO);

    ExportStatisticsPO getByMasterId(String masterId);

    void updateById(ExportStatisticsPO exportStatisticsPO);

    List<ExportStatisticsPO> getRecordsByUserId(String userId, String tenantId, Integer getRecordsNum, GetRecordsParamDTO param);

    Integer countRecord(String userId, String tenantId, GetRecordsParamDTO param);

    List<ExportStatisticsPO> getProcessingRecords();

    List<ExportStatisticsPO> getProcessingRecordsByUserId(String userId, String tenantId, String type, List<String> types);

    void updateRetryDownloadStateById(String masterId);

    void updateByStateAndId(ExportStatisticsPO exportStatisticsPO, Long id, Integer state);
}
